/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;
import pl.poznan.put.notation.LeontisWesthof;
import pl.poznan.put.pdb.ImmutablePdbNamedResidueIdentifier;
import pl.poznan.put.pdb.PdbNamedResidueIdentifier;
import pl.poznan.put.rna.InteractionType;
import pl.poznan.put.structure.BasePair;
import pl.poznan.put.structure.ClassifiedBasePair;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.ImmutableAnalyzedBasePair;
import pl.poznan.put.structure.ImmutableBasePair;
import pl.poznan.put.structure.formats.BpSeq;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.ImmutableDefaultConverter;
import pl.poznan.put.structure.formats.ImmutableMultiLineDotBracket;

@Value.Immutable
public abstract class MultiLineDotBracket {
    /*
     * WARNING - void declaration
     */
    public static MultiLineDotBracket fromString(String input) {
        void var6_9;
        ArrayList<ImmutableAnalyzedBasePair> basePairs = new ArrayList<ImmutableAnalyzedBasePair>();
        String sequence = "";
        int previousLength = -1;
        String[] stringArray = StringUtils.split((String)input, (char)'\n');
        int n = stringArray.length;
        boolean bl = false;
        while (var6_9 < n) {
            String line = stringArray[var6_9];
            String[] tokens = StringUtils.split((String)line);
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Each line must contain two entities. An identifier (seq, cWW, etc.) and the content (sequence or dot-bracket notation). This line fails the check: " + line);
            }
            if (previousLength == -1) {
                previousLength = tokens[1].length();
            }
            if (tokens[1].length() != previousLength) {
                throw new IllegalArgumentException("Sequence and all dot-bracket structures must be of equal size. This line fails to meet the criterion: " + line);
            }
            previousLength = tokens[1].length();
            if ("seq".equalsIgnoreCase(tokens[0])) {
                sequence = tokens[1];
            } else {
                LeontisWesthof leontisWesthof = LeontisWesthof.fromString(tokens[0]);
                char[] dotsAndBrackets = tokens[1].toCharArray();
                HashMap stackMap = new HashMap();
                for (int i = 0; i < dotsAndBrackets.length; ++i) {
                    char c = dotsAndBrackets[i];
                    if (c == ',') continue;
                    if (DotBracketSymbol.isOpening(c)) {
                        if (!stackMap.containsKey(Character.valueOf(c))) {
                            stackMap.put(Character.valueOf(c), new Stack());
                        }
                        Stack stack = (Stack)stackMap.get(Character.valueOf(c));
                        stack.push(i);
                        continue;
                    }
                    if (DotBracketSymbol.isClosing(c)) {
                        char opening = DotBracketSymbol.matchingBracket(c);
                        if (!stackMap.containsKey(Character.valueOf(opening))) {
                            throw new IllegalArgumentException(String.format("Invalid dot-bracket structure. Closing bracket '%s' at position %d occurred when unexpected", Character.valueOf(c), i + 1));
                        }
                        Stack stack = (Stack)stackMap.get(Character.valueOf(opening));
                        if (stack.empty()) {
                            throw new IllegalArgumentException(String.format("Invalid dot-bracket structure. Closing bracket '%s' at position %d occurred when unexpected", Character.valueOf(c), i + 1));
                        }
                        int openingIndex = (Integer)stack.pop();
                        ImmutablePdbNamedResidueIdentifier left = ImmutablePdbNamedResidueIdentifier.of("A", openingIndex + 1, " ", sequence.length() > openingIndex ? sequence.charAt(openingIndex) : (char)'N');
                        ImmutablePdbNamedResidueIdentifier right = ImmutablePdbNamedResidueIdentifier.of("A", i + 1, " ", sequence.length() > i ? sequence.charAt(i) : (char)'N');
                        ImmutableBasePair basePair = ImmutableBasePair.of(left, right);
                        ImmutableAnalyzedBasePair classifiedBasePair = ImmutableAnalyzedBasePair.of(basePair).withLeontisWesthof(leontisWesthof);
                        basePairs.add(classifiedBasePair);
                        continue;
                    }
                    if (c == '.') continue;
                    throw new IllegalArgumentException("Invalid character '" + c + "' in dot-bracket " + tokens[1]);
                }
                for (Map.Entry entry : stackMap.entrySet()) {
                    if (((Stack)entry.getValue()).empty()) continue;
                    throw new IllegalArgumentException("Invalid dot-bracket structure. Not all opened brackets have been closed: " + tokens[1]);
                }
            }
            ++var6_9;
        }
        if (StringUtils.isBlank((CharSequence)sequence)) {
            int maxIndex = Integer.MIN_VALUE;
            for (ClassifiedBasePair classifiedBasePair : basePairs) {
                maxIndex = Integer.max(maxIndex, classifiedBasePair.basePair().right().residueNumber());
            }
            sequence = StringUtils.repeat((char)'N', (int)maxIndex);
        }
        return ImmutableMultiLineDotBracket.of(sequence, basePairs);
    }

    @Value.Parameter(order=1)
    public abstract String sequence();

    @Value.Parameter(order=2)
    public abstract Collection<? extends ClassifiedBasePair> basePairs();

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("seq ").append(this.sequence()).append('\n');
        Set set = this.basePairs5to3().stream().map(ClassifiedBasePair::leontisWesthof).collect(Collectors.toSet());
        for (LeontisWesthof leontisWesthof : LeontisWesthof.values()) {
            if (leontisWesthof == LeontisWesthof.UNKNOWN || !set.contains((Object)leontisWesthof)) continue;
            for (DotBracket dotBracket : this.dotBracketFromBasePairs(leontisWesthof)) {
                builder.append(leontisWesthof.shortName()).append(' ').append(dotBracket.structure()).append('\n');
            }
        }
        return builder.toString();
    }

    @Value.Lazy
    protected Collection<ClassifiedBasePair> basePairs5to3() {
        return this.basePairs().stream().filter(basePair -> basePair.basePair().is5to3()).collect(Collectors.toSet());
    }

    private List<DotBracket> dotBracketFromBasePairs(LeontisWesthof leontisWesthof) {
        List filteredBasePairs = this.basePairs5to3().stream().filter(cbp -> InteractionType.BASE_BASE.equals(cbp.interactionType())).filter(cbp -> leontisWesthof == cbp.leontisWesthof()).sorted(Comparator.comparingInt(cbp -> cbp.basePair().left().residueNumber())).collect(Collectors.toList());
        ArrayList<DotBracket> result = new ArrayList<DotBracket>();
        do {
            LinkedHashSet<ClassifiedBasePair> layer = new LinkedHashSet<ClassifiedBasePair>();
            HashSet<Integer> usedIndices = new HashSet<Integer>();
            for (ClassifiedBasePair classifiedBasePair : filteredBasePairs) {
                BasePair basePair = classifiedBasePair.basePair();
                int left = basePair.left().residueNumber();
                int right = basePair.right().residueNumber();
                if (usedIndices.contains(left) || usedIndices.contains(right)) continue;
                layer.add(classifiedBasePair);
                usedIndices.add(left);
                usedIndices.add(right);
            }
            result.add(this.basePairsToDotBracket(layer));
            filteredBasePairs.removeAll(layer);
        } while (!filteredBasePairs.isEmpty());
        return result;
    }

    private DotBracket basePairsToDotBracket(Collection<ClassifiedBasePair> filteredBasePairs) {
        ArrayList<PdbNamedResidueIdentifier> identifiers = new ArrayList<PdbNamedResidueIdentifier>();
        char[] array = this.sequence().toCharArray();
        for (int i = 0; i < array.length; ++i) {
            ImmutablePdbNamedResidueIdentifier identifier = ImmutablePdbNamedResidueIdentifier.of("A", i + 1, " ", array[i]);
            identifiers.add(identifier);
        }
        BpSeq bpSeq = BpSeq.fromBasePairs(identifiers, filteredBasePairs);
        ImmutableDefaultConverter converter = ImmutableDefaultConverter.of();
        return converter.convert(bpSeq);
    }
}

