/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.Strand;
import pl.poznan.put.structure.formats.StrandView;

@ParametersAreNonnullByDefault
@Generated(from="StrandView", generator="Immutables")
@Immutable
public final class ImmutableStrandView
extends StrandView {
    private final List<DotBracket> combineStrands;
    private final String name;
    private final int begin;
    private final int end;
    private final DotBracket parent;
    private volatile transient long lazyInitBitmap;
    private static final long SYMBOLS_LAZY_INIT_BIT = 1L;
    private transient List<DotBracketSymbol> symbols;

    private ImmutableStrandView(String name, DotBracket parent, int begin, int end) {
        this.name = Objects.requireNonNull(name, "name");
        this.parent = Objects.requireNonNull(parent, "parent");
        this.begin = begin;
        this.end = end;
        this.combineStrands = Collections.emptyList();
    }

    private ImmutableStrandView(List<DotBracket> combineStrands, String name, int begin, int end, DotBracket parent) {
        this.combineStrands = combineStrands;
        this.name = name;
        this.begin = begin;
        this.end = end;
        this.parent = parent;
    }

    @Override
    public List<DotBracket> combineStrands() {
        return this.combineStrands;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int begin() {
        return this.begin;
    }

    @Override
    public int end() {
        return this.end;
    }

    @Override
    public DotBracket parent() {
        return this.parent;
    }

    public final ImmutableStrandView withCombineStrands(DotBracket ... elements) {
        List<DotBracket> newValue = ImmutableStrandView.createUnmodifiableList(false, ImmutableStrandView.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableStrandView(newValue, this.name, this.begin, this.end, this.parent);
    }

    public final ImmutableStrandView withCombineStrands(Iterable<? extends DotBracket> elements) {
        if (this.combineStrands == elements) {
            return this;
        }
        List<DotBracket> newValue = ImmutableStrandView.createUnmodifiableList(false, ImmutableStrandView.createSafeList(elements, true, false));
        return new ImmutableStrandView(newValue, this.name, this.begin, this.end, this.parent);
    }

    public final ImmutableStrandView withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableStrandView(this.combineStrands, newValue, this.begin, this.end, this.parent);
    }

    public final ImmutableStrandView withBegin(int value) {
        if (this.begin == value) {
            return this;
        }
        return new ImmutableStrandView(this.combineStrands, this.name, value, this.end, this.parent);
    }

    public final ImmutableStrandView withEnd(int value) {
        if (this.end == value) {
            return this;
        }
        return new ImmutableStrandView(this.combineStrands, this.name, this.begin, value, this.parent);
    }

    public final ImmutableStrandView withParent(DotBracket value) {
        if (this.parent == value) {
            return this;
        }
        DotBracket newValue = Objects.requireNonNull(value, "parent");
        return new ImmutableStrandView(this.combineStrands, this.name, this.begin, this.end, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStrandView && this.equalTo((ImmutableStrandView)another);
    }

    private boolean equalTo(ImmutableStrandView another) {
        return this.combineStrands.equals(another.combineStrands) && this.name.equals(another.name) && this.begin == another.begin && this.end == another.end && this.parent.equals(another.parent);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.combineStrands.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.begin;
        h += (h << 5) + this.end;
        h += (h << 5) + this.parent.hashCode();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DotBracketSymbol> symbols() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableStrandView immutableStrandView = this;
            synchronized (immutableStrandView) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.symbols = Objects.requireNonNull(super.symbols(), "symbols");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.symbols;
    }

    public static ImmutableStrandView of(String name, DotBracket parent, int begin, int end) {
        return new ImmutableStrandView(name, parent, begin, end);
    }

    public static ImmutableStrandView copyOf(StrandView instance) {
        if (instance instanceof ImmutableStrandView) {
            return (ImmutableStrandView)instance;
        }
        return ImmutableStrandView.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="StrandView", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_BEGIN = 2L;
        private static final long INIT_BIT_END = 4L;
        private static final long INIT_BIT_PARENT = 8L;
        private long initBits = 15L;
        private List<DotBracket> combineStrands = new ArrayList<DotBracket>();
        @Nullable
        private String name;
        private int begin;
        private int end;
        @Nullable
        private DotBracket parent;

        private Builder() {
        }

        public final Builder from(DotBracket instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(StrandView instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Strand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DotBracket instance;
            long bits = 0L;
            if (object instanceof DotBracket) {
                instance = (DotBracket)object;
                this.addAllCombineStrands(instance.combineStrands());
            }
            if (object instanceof StrandView) {
                instance = (StrandView)object;
                if ((bits & 1L) == 0L) {
                    this.name(((StrandView)instance).name());
                    bits |= 1L;
                }
                this.parent(((StrandView)instance).parent());
                if ((bits & 2L) == 0L) {
                    this.end(((StrandView)instance).end());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.begin(((StrandView)instance).begin());
                    bits |= 4L;
                }
            }
            if (object instanceof Strand) {
                instance = (Strand)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.name());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.begin(instance.begin());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.end(instance.end());
                    bits |= 2L;
                }
            }
        }

        public final Builder addCombineStrands(DotBracket element) {
            this.combineStrands.add(Objects.requireNonNull(element, "combineStrands element"));
            return this;
        }

        public final Builder addCombineStrands(DotBracket ... elements) {
            for (DotBracket element : elements) {
                this.combineStrands.add(Objects.requireNonNull(element, "combineStrands element"));
            }
            return this;
        }

        public final Builder combineStrands(Iterable<? extends DotBracket> elements) {
            this.combineStrands.clear();
            return this.addAllCombineStrands(elements);
        }

        public final Builder addAllCombineStrands(Iterable<? extends DotBracket> elements) {
            for (DotBracket dotBracket : elements) {
                this.combineStrands.add(Objects.requireNonNull(dotBracket, "combineStrands element"));
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder begin(int begin) {
            this.begin = begin;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder end(int end) {
            this.end = end;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder parent(DotBracket parent) {
            this.parent = Objects.requireNonNull(parent, "parent");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableStrandView build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStrandView(ImmutableStrandView.createUnmodifiableList(true, this.combineStrands), this.name, this.begin, this.end, this.parent);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("begin");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("end");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("parent");
            }
            return "Cannot build StrandView, some of required attributes are not set " + attributes;
        }
    }
}

