/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.formats.BpSeq;
import pl.poznan.put.structure.formats.DefaultConverter;

@ParametersAreNonnullByDefault
@Generated(from="DefaultConverter.State", generator="Immutables")
@Immutable
final class ImmutableState
extends DefaultConverter.State {
    @Nullable
    private final DefaultConverter.State parent;
    private final BpSeq bpSeq;
    private final int level;
    private volatile transient long lazyInitBitmap;
    private static final long SCORE_LAZY_INIT_BIT = 1L;
    private transient int score;

    private ImmutableState(Optional<? extends DefaultConverter.State> parent, BpSeq bpSeq, int level) {
        this.parent = parent.orElse(null);
        this.bpSeq = Objects.requireNonNull(bpSeq, "bpSeq");
        this.level = level;
    }

    private ImmutableState(ImmutableState original, @Nullable DefaultConverter.State parent, BpSeq bpSeq, int level) {
        this.parent = parent;
        this.bpSeq = bpSeq;
        this.level = level;
    }

    @Override
    public Optional<DefaultConverter.State> parent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public BpSeq bpSeq() {
        return this.bpSeq;
    }

    @Override
    public int level() {
        return this.level;
    }

    public final ImmutableState withParent(DefaultConverter.State value) {
        DefaultConverter.State newValue = Objects.requireNonNull(value, "parent");
        if (this.parent == newValue) {
            return this;
        }
        return new ImmutableState(this, newValue, this.bpSeq, this.level);
    }

    public final ImmutableState withParent(Optional<? extends DefaultConverter.State> optional) {
        DefaultConverter.State value = optional.orElse(null);
        if (this.parent == value) {
            return this;
        }
        return new ImmutableState(this, value, this.bpSeq, this.level);
    }

    public final ImmutableState withBpSeq(BpSeq value) {
        if (this.bpSeq == value) {
            return this;
        }
        BpSeq newValue = Objects.requireNonNull(value, "bpSeq");
        return new ImmutableState(this, this.parent, newValue, this.level);
    }

    public final ImmutableState withLevel(int value) {
        if (this.level == value) {
            return this;
        }
        return new ImmutableState(this, this.parent, this.bpSeq, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableState && this.equalTo((ImmutableState)another);
    }

    private boolean equalTo(ImmutableState another) {
        return Objects.equals(this.parent, another.parent) && this.bpSeq.equals(another.bpSeq) && this.level == another.level;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.parent);
        h += (h << 5) + this.bpSeq.hashCode();
        h += (h << 5) + this.level;
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("State{");
        if (this.parent != null) {
            builder.append("parent=").append(this.parent);
        }
        if (builder.length() > 6) {
            builder.append(", ");
        }
        builder.append("bpSeq=").append(this.bpSeq);
        builder.append(", ");
        builder.append("level=").append(this.level);
        return builder.append("}").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int score() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableState immutableState = this;
            synchronized (immutableState) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.score = super.score();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.score;
    }

    public static ImmutableState of(Optional<? extends DefaultConverter.State> parent, BpSeq bpSeq, int level) {
        return new ImmutableState(parent, bpSeq, level);
    }

    public static ImmutableState copyOf(DefaultConverter.State instance) {
        if (instance instanceof ImmutableState) {
            return (ImmutableState)instance;
        }
        return ImmutableState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DefaultConverter.State", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BP_SEQ = 1L;
        private static final long INIT_BIT_LEVEL = 2L;
        private long initBits = 3L;
        @Nullable
        private DefaultConverter.State parent;
        @Nullable
        private BpSeq bpSeq;
        private int level;

        private Builder() {
        }

        public final Builder from(DefaultConverter.State instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<DefaultConverter.State> parentOptional = instance.parent();
            if (parentOptional.isPresent()) {
                this.parent(parentOptional);
            }
            this.bpSeq(instance.bpSeq());
            this.level(instance.level());
            return this;
        }

        public final Builder parent(DefaultConverter.State parent) {
            this.parent = Objects.requireNonNull(parent, "parent");
            return this;
        }

        public final Builder parent(Optional<? extends DefaultConverter.State> parent) {
            this.parent = parent.orElse(null);
            return this;
        }

        public final Builder bpSeq(BpSeq bpSeq) {
            this.bpSeq = Objects.requireNonNull(bpSeq, "bpSeq");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder level(int level) {
            this.level = level;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableState(null, this.parent, this.bpSeq, this.level);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bpSeq");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("level");
            }
            return "Cannot build State, some of required attributes are not set " + attributes;
        }
    }
}

