/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.formats.Ct;

@ParametersAreNonnullByDefault
@Generated(from="Ct.ExtendedEntry", generator="Immutables")
@Immutable
public final class ImmutableExtendedEntry
extends Ct.ExtendedEntry {
    private final int index;
    private final char seq;
    private final int before;
    private final int after;
    private final int pair;
    private final int original;
    private final String comment;

    private ImmutableExtendedEntry(int index, char seq, int before, int after, int pair, int original) {
        this.index = index;
        this.seq = seq;
        this.before = before;
        this.after = after;
        this.pair = pair;
        this.original = original;
        this.comment = Objects.requireNonNull(super.comment(), "comment");
    }

    private ImmutableExtendedEntry(Builder builder) {
        this.index = builder.index;
        this.seq = builder.seq;
        this.before = builder.before;
        this.after = builder.after;
        this.pair = builder.pair;
        this.original = builder.original;
        this.comment = builder.comment != null ? builder.comment : Objects.requireNonNull(super.comment(), "comment");
    }

    private ImmutableExtendedEntry(int index, char seq, int before, int after, int pair, int original, String comment) {
        this.index = index;
        this.seq = seq;
        this.before = before;
        this.after = after;
        this.pair = pair;
        this.original = original;
        this.comment = comment;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public char seq() {
        return this.seq;
    }

    @Override
    public int before() {
        return this.before;
    }

    @Override
    public int after() {
        return this.after;
    }

    @Override
    public int pair() {
        return this.pair;
    }

    @Override
    public int original() {
        return this.original;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    public final ImmutableExtendedEntry withIndex(int value) {
        if (this.index == value) {
            return this;
        }
        return new ImmutableExtendedEntry(value, this.seq, this.before, this.after, this.pair, this.original, this.comment);
    }

    public final ImmutableExtendedEntry withSeq(char value) {
        if (this.seq == value) {
            return this;
        }
        return new ImmutableExtendedEntry(this.index, value, this.before, this.after, this.pair, this.original, this.comment);
    }

    public final ImmutableExtendedEntry withBefore(int value) {
        if (this.before == value) {
            return this;
        }
        return new ImmutableExtendedEntry(this.index, this.seq, value, this.after, this.pair, this.original, this.comment);
    }

    public final ImmutableExtendedEntry withAfter(int value) {
        if (this.after == value) {
            return this;
        }
        return new ImmutableExtendedEntry(this.index, this.seq, this.before, value, this.pair, this.original, this.comment);
    }

    public final ImmutableExtendedEntry withPair(int value) {
        if (this.pair == value) {
            return this;
        }
        return new ImmutableExtendedEntry(this.index, this.seq, this.before, this.after, value, this.original, this.comment);
    }

    public final ImmutableExtendedEntry withOriginal(int value) {
        if (this.original == value) {
            return this;
        }
        return new ImmutableExtendedEntry(this.index, this.seq, this.before, this.after, this.pair, value, this.comment);
    }

    public final ImmutableExtendedEntry withComment(String value) {
        String newValue = Objects.requireNonNull(value, "comment");
        if (this.comment.equals(newValue)) {
            return this;
        }
        return new ImmutableExtendedEntry(this.index, this.seq, this.before, this.after, this.pair, this.original, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExtendedEntry && this.equalTo((ImmutableExtendedEntry)another);
    }

    private boolean equalTo(ImmutableExtendedEntry another) {
        return this.index == another.index && this.seq == another.seq && this.before == another.before && this.after == another.after && this.pair == another.pair && this.original == another.original && this.comment.equals(another.comment);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.index;
        h += (h << 5) + Character.hashCode(this.seq);
        h += (h << 5) + this.before;
        h += (h << 5) + this.after;
        h += (h << 5) + this.pair;
        h += (h << 5) + this.original;
        h += (h << 5) + this.comment.hashCode();
        return h;
    }

    public static ImmutableExtendedEntry of(int index, char seq, int before, int after, int pair, int original) {
        return new ImmutableExtendedEntry(index, seq, before, after, pair, original);
    }

    public static ImmutableExtendedEntry copyOf(Ct.ExtendedEntry instance) {
        if (instance instanceof ImmutableExtendedEntry) {
            return (ImmutableExtendedEntry)instance;
        }
        return ImmutableExtendedEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Ct.ExtendedEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INDEX = 1L;
        private static final long INIT_BIT_SEQ = 2L;
        private static final long INIT_BIT_BEFORE = 4L;
        private static final long INIT_BIT_AFTER = 8L;
        private static final long INIT_BIT_PAIR = 16L;
        private static final long INIT_BIT_ORIGINAL = 32L;
        private long initBits = 63L;
        private int index;
        private char seq;
        private int before;
        private int after;
        private int pair;
        private int original;
        @Nullable
        private String comment;

        private Builder() {
        }

        public final Builder from(Ct.ExtendedEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.index(instance.index());
            this.seq(instance.seq());
            this.before(instance.before());
            this.after(instance.after());
            this.pair(instance.pair());
            this.original(instance.original());
            this.comment(instance.comment());
            return this;
        }

        public final Builder index(int index) {
            this.index = index;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder seq(char seq) {
            this.seq = seq;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder before(int before) {
            this.before = before;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder after(int after) {
            this.after = after;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder pair(int pair) {
            this.pair = pair;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder original(int original) {
            this.original = original;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder comment(String comment) {
            this.comment = Objects.requireNonNull(comment, "comment");
            return this;
        }

        public ImmutableExtendedEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExtendedEntry(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("index");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("seq");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("before");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("after");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("pair");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("original");
            }
            return "Cannot build ExtendedEntry, some of required attributes are not set " + attributes;
        }
    }
}

