/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.formats.BpSeq;

@ParametersAreNonnullByDefault
@Generated(from="BpSeq.Entry", generator="Immutables")
@Immutable
public final class ImmutableEntry
extends BpSeq.Entry {
    private final int index;
    private final char seq;
    private final int pair;
    private final String comment;

    private ImmutableEntry(int index, char seq, int pair) {
        this.index = index;
        this.seq = seq;
        this.pair = pair;
        this.comment = Objects.requireNonNull(super.comment(), "comment");
    }

    private ImmutableEntry(Builder builder) {
        this.index = builder.index;
        this.seq = builder.seq;
        this.pair = builder.pair;
        this.comment = builder.comment != null ? builder.comment : Objects.requireNonNull(super.comment(), "comment");
    }

    private ImmutableEntry(int index, char seq, int pair, String comment) {
        this.index = index;
        this.seq = seq;
        this.pair = pair;
        this.comment = comment;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public char seq() {
        return this.seq;
    }

    @Override
    public int pair() {
        return this.pair;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    public final ImmutableEntry withIndex(int value) {
        if (this.index == value) {
            return this;
        }
        return new ImmutableEntry(value, this.seq, this.pair, this.comment);
    }

    public final ImmutableEntry withSeq(char value) {
        if (this.seq == value) {
            return this;
        }
        return new ImmutableEntry(this.index, value, this.pair, this.comment);
    }

    public final ImmutableEntry withPair(int value) {
        if (this.pair == value) {
            return this;
        }
        return new ImmutableEntry(this.index, this.seq, value, this.comment);
    }

    public final ImmutableEntry withComment(String value) {
        String newValue = Objects.requireNonNull(value, "comment");
        if (this.comment.equals(newValue)) {
            return this;
        }
        return new ImmutableEntry(this.index, this.seq, this.pair, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntry && this.equalTo((ImmutableEntry)another);
    }

    private boolean equalTo(ImmutableEntry another) {
        return this.index == another.index && this.seq == another.seq && this.pair == another.pair && this.comment.equals(another.comment);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.index;
        h += (h << 5) + Character.hashCode(this.seq);
        h += (h << 5) + this.pair;
        h += (h << 5) + this.comment.hashCode();
        return h;
    }

    public static ImmutableEntry of(int index, char seq, int pair) {
        return new ImmutableEntry(index, seq, pair);
    }

    public static ImmutableEntry copyOf(BpSeq.Entry instance) {
        if (instance instanceof ImmutableEntry) {
            return (ImmutableEntry)instance;
        }
        return ImmutableEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BpSeq.Entry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INDEX = 1L;
        private static final long INIT_BIT_SEQ = 2L;
        private static final long INIT_BIT_PAIR = 4L;
        private long initBits = 7L;
        private int index;
        private char seq;
        private int pair;
        @Nullable
        private String comment;

        private Builder() {
        }

        public final Builder from(BpSeq.Entry instance) {
            Objects.requireNonNull(instance, "instance");
            this.index(instance.index());
            this.seq(instance.seq());
            this.pair(instance.pair());
            this.comment(instance.comment());
            return this;
        }

        public final Builder index(int index) {
            this.index = index;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder seq(char seq) {
            this.seq = seq;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder pair(int pair) {
            this.pair = pair;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder comment(String comment) {
            this.comment = Objects.requireNonNull(comment, "comment");
            return this;
        }

        public ImmutableEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEntry(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("index");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("seq");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("pair");
            }
            return "Cannot build Entry, some of required attributes are not set " + attributes;
        }
    }
}

