/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.formats.DefaultStrand;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.Strand;

@ParametersAreNonnullByDefault
@Generated(from="DefaultStrand", generator="Immutables")
@Immutable
public final class ImmutableDefaultStrand
extends DefaultStrand {
    private final List<DotBracket> combineStrands;
    private final String name;
    private final List<DotBracketSymbol> symbols;

    private ImmutableDefaultStrand(String name, Iterable<? extends DotBracketSymbol> symbols) {
        this.name = Objects.requireNonNull(name, "name");
        this.symbols = ImmutableDefaultStrand.createUnmodifiableList(false, ImmutableDefaultStrand.createSafeList(symbols, true, false));
        this.combineStrands = Collections.emptyList();
    }

    private ImmutableDefaultStrand(List<DotBracket> combineStrands, String name, List<DotBracketSymbol> symbols) {
        this.combineStrands = combineStrands;
        this.name = name;
        this.symbols = symbols;
    }

    @Override
    public List<DotBracket> combineStrands() {
        return this.combineStrands;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<DotBracketSymbol> symbols() {
        return this.symbols;
    }

    public final ImmutableDefaultStrand withCombineStrands(DotBracket ... elements) {
        List<DotBracket> newValue = ImmutableDefaultStrand.createUnmodifiableList(false, ImmutableDefaultStrand.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDefaultStrand(newValue, this.name, this.symbols);
    }

    public final ImmutableDefaultStrand withCombineStrands(Iterable<? extends DotBracket> elements) {
        if (this.combineStrands == elements) {
            return this;
        }
        List<DotBracket> newValue = ImmutableDefaultStrand.createUnmodifiableList(false, ImmutableDefaultStrand.createSafeList(elements, true, false));
        return new ImmutableDefaultStrand(newValue, this.name, this.symbols);
    }

    public final ImmutableDefaultStrand withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableDefaultStrand(this.combineStrands, newValue, this.symbols);
    }

    public final ImmutableDefaultStrand withSymbols(DotBracketSymbol ... elements) {
        List<DotBracketSymbol> newValue = ImmutableDefaultStrand.createUnmodifiableList(false, ImmutableDefaultStrand.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDefaultStrand(this.combineStrands, this.name, newValue);
    }

    public final ImmutableDefaultStrand withSymbols(Iterable<? extends DotBracketSymbol> elements) {
        if (this.symbols == elements) {
            return this;
        }
        List<DotBracketSymbol> newValue = ImmutableDefaultStrand.createUnmodifiableList(false, ImmutableDefaultStrand.createSafeList(elements, true, false));
        return new ImmutableDefaultStrand(this.combineStrands, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultStrand && this.equalTo((ImmutableDefaultStrand)another);
    }

    private boolean equalTo(ImmutableDefaultStrand another) {
        return this.combineStrands.equals(another.combineStrands) && this.name.equals(another.name) && this.symbols.equals(another.symbols);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.combineStrands.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.symbols.hashCode();
        return h;
    }

    public static ImmutableDefaultStrand of(String name, List<DotBracketSymbol> symbols) {
        return ImmutableDefaultStrand.of(name, symbols);
    }

    public static ImmutableDefaultStrand of(String name, Iterable<? extends DotBracketSymbol> symbols) {
        return new ImmutableDefaultStrand(name, symbols);
    }

    public static ImmutableDefaultStrand copyOf(DefaultStrand instance) {
        if (instance instanceof ImmutableDefaultStrand) {
            return (ImmutableDefaultStrand)instance;
        }
        return ImmutableDefaultStrand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="DefaultStrand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private List<DotBracket> combineStrands = new ArrayList<DotBracket>();
        @Nullable
        private String name;
        private List<DotBracketSymbol> symbols = new ArrayList<DotBracketSymbol>();

        private Builder() {
        }

        public final Builder from(DefaultStrand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DotBracket instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Strand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DotBracket instance;
            long bits = 0L;
            if (object instanceof DefaultStrand) {
                instance = (DefaultStrand)object;
                if ((bits & 1L) == 0L) {
                    this.name(((DefaultStrand)instance).name());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllSymbols(((DefaultStrand)instance).symbols());
                    bits |= 2L;
                }
            }
            if (object instanceof DotBracket) {
                instance = (DotBracket)object;
                this.addAllCombineStrands(instance.combineStrands());
                if ((bits & 2L) == 0L) {
                    this.addAllSymbols(instance.symbols());
                    bits |= 2L;
                }
            }
            if (object instanceof Strand) {
                instance = (Strand)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.name());
                    bits |= 1L;
                }
            }
        }

        public final Builder addCombineStrands(DotBracket element) {
            this.combineStrands.add(Objects.requireNonNull(element, "combineStrands element"));
            return this;
        }

        public final Builder addCombineStrands(DotBracket ... elements) {
            for (DotBracket element : elements) {
                this.combineStrands.add(Objects.requireNonNull(element, "combineStrands element"));
            }
            return this;
        }

        public final Builder combineStrands(Iterable<? extends DotBracket> elements) {
            this.combineStrands.clear();
            return this.addAllCombineStrands(elements);
        }

        public final Builder addAllCombineStrands(Iterable<? extends DotBracket> elements) {
            for (DotBracket dotBracket : elements) {
                this.combineStrands.add(Objects.requireNonNull(dotBracket, "combineStrands element"));
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSymbols(DotBracketSymbol element) {
            this.symbols.add(Objects.requireNonNull(element, "symbols element"));
            return this;
        }

        public final Builder addSymbols(DotBracketSymbol ... elements) {
            for (DotBracketSymbol element : elements) {
                this.symbols.add(Objects.requireNonNull(element, "symbols element"));
            }
            return this;
        }

        public final Builder symbols(Iterable<? extends DotBracketSymbol> elements) {
            this.symbols.clear();
            return this.addAllSymbols(elements);
        }

        public final Builder addAllSymbols(Iterable<? extends DotBracketSymbol> elements) {
            for (DotBracketSymbol dotBracketSymbol : elements) {
                this.symbols.add(Objects.requireNonNull(dotBracketSymbol, "symbols element"));
            }
            return this;
        }

        public ImmutableDefaultStrand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDefaultStrand(ImmutableDefaultStrand.createUnmodifiableList(true, this.combineStrands), this.name, ImmutableDefaultStrand.createUnmodifiableList(true, this.symbols));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build DefaultStrand, some of required attributes are not set " + attributes;
        }
    }
}

