/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.pdb.analysis.PdbModel;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.formats.DefaultDotBracketFromPdb;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.DotBracketFromPdb;
import pl.poznan.put.structure.formats.Strand;

@ParametersAreNonnullByDefault
@Generated(from="DefaultDotBracketFromPdb", generator="Immutables")
@Immutable
public final class ImmutableDefaultDotBracketFromPdb
extends DefaultDotBracketFromPdb {
    private final Set<PdbResidueIdentifier> identifierSet;
    private final PdbModel model;
    private final List<Strand> strands;
    private final String sequence;
    private final String structure;
    private volatile transient long lazyInitBitmap;
    private static final long PAIRS_LAZY_INIT_BIT = 1L;
    private transient Map<DotBracketSymbol, DotBracketSymbol> pairs;
    private static final long RESIDUE_TO_SYMBOL_LAZY_INIT_BIT = 2L;
    private transient Map<PdbResidueIdentifier, DotBracketSymbol> residueToSymbol;
    private static final long SYMBOL_TO_RESIDUE_LAZY_INIT_BIT = 4L;
    private transient Map<DotBracketSymbol, PdbResidueIdentifier> symbolToResidue;

    private ImmutableDefaultDotBracketFromPdb(String sequence, String structure, PdbModel model) {
        this.sequence = Objects.requireNonNull(sequence, "sequence");
        this.structure = Objects.requireNonNull(structure, "structure");
        this.model = Objects.requireNonNull(model, "model");
        this.identifierSet = Collections.emptySet();
        this.strands = ImmutableDefaultDotBracketFromPdb.createUnmodifiableList(false, ImmutableDefaultDotBracketFromPdb.createSafeList(super.strands(), true, false));
    }

    private ImmutableDefaultDotBracketFromPdb(Builder builder) {
        this.identifierSet = ImmutableDefaultDotBracketFromPdb.createUnmodifiableSet(builder.identifierSet);
        this.model = builder.model;
        this.sequence = builder.sequence;
        this.structure = builder.structure;
        this.strands = builder.strandsIsSet() ? ImmutableDefaultDotBracketFromPdb.createUnmodifiableList(true, builder.strands) : ImmutableDefaultDotBracketFromPdb.createUnmodifiableList(false, ImmutableDefaultDotBracketFromPdb.createSafeList(super.strands(), true, false));
    }

    private ImmutableDefaultDotBracketFromPdb(Set<PdbResidueIdentifier> identifierSet, PdbModel model, List<Strand> strands, String sequence, String structure) {
        this.identifierSet = identifierSet;
        this.model = model;
        this.strands = strands;
        this.sequence = sequence;
        this.structure = structure;
    }

    @Override
    public Set<PdbResidueIdentifier> identifierSet() {
        return this.identifierSet;
    }

    @Override
    public PdbModel model() {
        return this.model;
    }

    @Override
    public List<Strand> strands() {
        return this.strands;
    }

    @Override
    public String sequence() {
        return this.sequence;
    }

    @Override
    public String structure() {
        return this.structure;
    }

    public final ImmutableDefaultDotBracketFromPdb withIdentifierSet(PdbResidueIdentifier ... elements) {
        Set<PdbResidueIdentifier> newValue = ImmutableDefaultDotBracketFromPdb.createUnmodifiableSet(ImmutableDefaultDotBracketFromPdb.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableDefaultDotBracketFromPdb.validate(new ImmutableDefaultDotBracketFromPdb(newValue, this.model, this.strands, this.sequence, this.structure));
    }

    public final ImmutableDefaultDotBracketFromPdb withIdentifierSet(Iterable<? extends PdbResidueIdentifier> elements) {
        if (this.identifierSet == elements) {
            return this;
        }
        Set<PdbResidueIdentifier> newValue = ImmutableDefaultDotBracketFromPdb.createUnmodifiableSet(ImmutableDefaultDotBracketFromPdb.createSafeList(elements, true, false));
        return ImmutableDefaultDotBracketFromPdb.validate(new ImmutableDefaultDotBracketFromPdb(newValue, this.model, this.strands, this.sequence, this.structure));
    }

    public final ImmutableDefaultDotBracketFromPdb withModel(PdbModel value) {
        if (this.model == value) {
            return this;
        }
        PdbModel newValue = Objects.requireNonNull(value, "model");
        return ImmutableDefaultDotBracketFromPdb.validate(new ImmutableDefaultDotBracketFromPdb(this.identifierSet, newValue, this.strands, this.sequence, this.structure));
    }

    public final ImmutableDefaultDotBracketFromPdb withStrands(Strand ... elements) {
        List<Strand> newValue = ImmutableDefaultDotBracketFromPdb.createUnmodifiableList(false, ImmutableDefaultDotBracketFromPdb.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableDefaultDotBracketFromPdb.validate(new ImmutableDefaultDotBracketFromPdb(this.identifierSet, this.model, newValue, this.sequence, this.structure));
    }

    public final ImmutableDefaultDotBracketFromPdb withStrands(Iterable<? extends Strand> elements) {
        if (this.strands == elements) {
            return this;
        }
        List<Strand> newValue = ImmutableDefaultDotBracketFromPdb.createUnmodifiableList(false, ImmutableDefaultDotBracketFromPdb.createSafeList(elements, true, false));
        return ImmutableDefaultDotBracketFromPdb.validate(new ImmutableDefaultDotBracketFromPdb(this.identifierSet, this.model, newValue, this.sequence, this.structure));
    }

    public final ImmutableDefaultDotBracketFromPdb withSequence(String value) {
        String newValue = Objects.requireNonNull(value, "sequence");
        if (this.sequence.equals(newValue)) {
            return this;
        }
        return ImmutableDefaultDotBracketFromPdb.validate(new ImmutableDefaultDotBracketFromPdb(this.identifierSet, this.model, this.strands, newValue, this.structure));
    }

    public final ImmutableDefaultDotBracketFromPdb withStructure(String value) {
        String newValue = Objects.requireNonNull(value, "structure");
        if (this.structure.equals(newValue)) {
            return this;
        }
        return ImmutableDefaultDotBracketFromPdb.validate(new ImmutableDefaultDotBracketFromPdb(this.identifierSet, this.model, this.strands, this.sequence, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultDotBracketFromPdb && this.equalTo((ImmutableDefaultDotBracketFromPdb)another);
    }

    private boolean equalTo(ImmutableDefaultDotBracketFromPdb another) {
        return this.identifierSet.equals(another.identifierSet) && this.model.equals(another.model) && this.sequence.equals(another.sequence) && this.structure.equals(another.structure);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifierSet.hashCode();
        h += (h << 5) + this.model.hashCode();
        h += (h << 5) + this.sequence.hashCode();
        h += (h << 5) + this.structure.hashCode();
        return h;
    }

    public String toString() {
        return "DefaultDotBracketFromPdb{identifierSet=" + this.identifierSet + ", model=" + this.model + ", sequence=" + this.sequence + ", structure=" + this.structure + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<DotBracketSymbol, DotBracketSymbol> pairs() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableDefaultDotBracketFromPdb immutableDefaultDotBracketFromPdb = this;
            synchronized (immutableDefaultDotBracketFromPdb) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.pairs = Objects.requireNonNull(super.pairs(), "pairs");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.pairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<PdbResidueIdentifier, DotBracketSymbol> residueToSymbol() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableDefaultDotBracketFromPdb immutableDefaultDotBracketFromPdb = this;
            synchronized (immutableDefaultDotBracketFromPdb) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.residueToSymbol = Objects.requireNonNull(super.residueToSymbol(), "residueToSymbol");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.residueToSymbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<DotBracketSymbol, PdbResidueIdentifier> symbolToResidue() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableDefaultDotBracketFromPdb immutableDefaultDotBracketFromPdb = this;
            synchronized (immutableDefaultDotBracketFromPdb) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.symbolToResidue = Objects.requireNonNull(super.symbolToResidue(), "symbolToResidue");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.symbolToResidue;
    }

    public static ImmutableDefaultDotBracketFromPdb of(String sequence, String structure, PdbModel model) {
        return ImmutableDefaultDotBracketFromPdb.validate(new ImmutableDefaultDotBracketFromPdb(sequence, structure, model));
    }

    private static ImmutableDefaultDotBracketFromPdb validate(ImmutableDefaultDotBracketFromPdb instance) {
        instance = (ImmutableDefaultDotBracketFromPdb)instance.validate();
        return instance;
    }

    public static ImmutableDefaultDotBracketFromPdb copyOf(DefaultDotBracketFromPdb instance) {
        if (instance instanceof ImmutableDefaultDotBracketFromPdb) {
            return (ImmutableDefaultDotBracketFromPdb)instance;
        }
        return ImmutableDefaultDotBracketFromPdb.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="DefaultDotBracketFromPdb", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MODEL = 1L;
        private static final long INIT_BIT_SEQUENCE = 2L;
        private static final long INIT_BIT_STRUCTURE = 4L;
        private static final long OPT_BIT_STRANDS = 1L;
        private long initBits = 7L;
        private long optBits;
        private List<PdbResidueIdentifier> identifierSet = new ArrayList<PdbResidueIdentifier>();
        @Nullable
        private PdbModel model;
        private List<Strand> strands = new ArrayList<Strand>();
        @Nullable
        private String sequence;
        @Nullable
        private String structure;

        private Builder() {
        }

        public final Builder from(DefaultDotBracketFromPdb instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DotBracketFromPdb instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DotBracket instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DotBracket instance;
            long bits = 0L;
            if (object instanceof DefaultDotBracketFromPdb) {
                instance = (DefaultDotBracketFromPdb)object;
                if ((bits & 1L) == 0L) {
                    this.sequence(((DefaultDotBracketFromPdb)instance).sequence());
                    bits |= 1L;
                }
                this.model(((DefaultDotBracketFromPdb)instance).model());
                if ((bits & 2L) == 0L) {
                    this.structure(((DefaultDotBracketFromPdb)instance).structure());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllStrands(((DefaultDotBracketFromPdb)instance).strands());
                    bits |= 4L;
                }
            }
            if (object instanceof DotBracketFromPdb) {
                instance = (DotBracketFromPdb)object;
                this.addAllIdentifierSet(instance.identifierSet());
            }
            if (object instanceof DotBracket) {
                instance = (DotBracket)object;
                if ((bits & 1L) == 0L) {
                    this.sequence(instance.sequence());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.structure(instance.structure());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllStrands(instance.strands());
                    bits |= 4L;
                }
            }
        }

        public final Builder addIdentifierSet(PdbResidueIdentifier element) {
            this.identifierSet.add(Objects.requireNonNull(element, "identifierSet element"));
            return this;
        }

        public final Builder addIdentifierSet(PdbResidueIdentifier ... elements) {
            for (PdbResidueIdentifier element : elements) {
                this.identifierSet.add(Objects.requireNonNull(element, "identifierSet element"));
            }
            return this;
        }

        public final Builder identifierSet(Iterable<? extends PdbResidueIdentifier> elements) {
            this.identifierSet.clear();
            return this.addAllIdentifierSet(elements);
        }

        public final Builder addAllIdentifierSet(Iterable<? extends PdbResidueIdentifier> elements) {
            for (PdbResidueIdentifier pdbResidueIdentifier : elements) {
                this.identifierSet.add(Objects.requireNonNull(pdbResidueIdentifier, "identifierSet element"));
            }
            return this;
        }

        public final Builder model(PdbModel model) {
            this.model = Objects.requireNonNull(model, "model");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addStrands(Strand element) {
            this.strands.add(Objects.requireNonNull(element, "strands element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addStrands(Strand ... elements) {
            for (Strand element : elements) {
                this.strands.add(Objects.requireNonNull(element, "strands element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder strands(Iterable<? extends Strand> elements) {
            this.strands.clear();
            return this.addAllStrands(elements);
        }

        public final Builder addAllStrands(Iterable<? extends Strand> elements) {
            for (Strand strand : elements) {
                this.strands.add(Objects.requireNonNull(strand, "strands element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder sequence(String sequence) {
            this.sequence = Objects.requireNonNull(sequence, "sequence");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder structure(String structure) {
            this.structure = Objects.requireNonNull(structure, "structure");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableDefaultDotBracketFromPdb build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableDefaultDotBracketFromPdb.validate(new ImmutableDefaultDotBracketFromPdb(this));
        }

        private boolean strandsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("model");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sequence");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("structure");
            }
            return "Cannot build DefaultDotBracketFromPdb, some of required attributes are not set " + attributes;
        }
    }
}

