/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.formats.DefaultDotBracket;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.Strand;

@ParametersAreNonnullByDefault
@Generated(from="DefaultDotBracket", generator="Immutables")
@Immutable
public final class ImmutableDefaultDotBracket
extends DefaultDotBracket {
    private final List<Strand> strands;
    private final String sequence;
    private final String structure;
    private volatile transient long lazyInitBitmap;
    private static final long PAIRS_LAZY_INIT_BIT = 1L;
    private transient Map<DotBracketSymbol, DotBracketSymbol> pairs;

    private ImmutableDefaultDotBracket(String sequence, String structure) {
        this.sequence = Objects.requireNonNull(sequence, "sequence");
        this.structure = Objects.requireNonNull(structure, "structure");
        this.strands = ImmutableDefaultDotBracket.createUnmodifiableList(false, ImmutableDefaultDotBracket.createSafeList(super.strands(), true, false));
    }

    private ImmutableDefaultDotBracket(Builder builder) {
        this.sequence = builder.sequence;
        this.structure = builder.structure;
        this.strands = builder.strandsIsSet() ? ImmutableDefaultDotBracket.createUnmodifiableList(true, builder.strands) : ImmutableDefaultDotBracket.createUnmodifiableList(false, ImmutableDefaultDotBracket.createSafeList(super.strands(), true, false));
    }

    private ImmutableDefaultDotBracket(List<Strand> strands, String sequence, String structure) {
        this.strands = strands;
        this.sequence = sequence;
        this.structure = structure;
    }

    @Override
    public List<Strand> strands() {
        return this.strands;
    }

    @Override
    public String sequence() {
        return this.sequence;
    }

    @Override
    public String structure() {
        return this.structure;
    }

    public final ImmutableDefaultDotBracket withStrands(Strand ... elements) {
        List<Strand> newValue = ImmutableDefaultDotBracket.createUnmodifiableList(false, ImmutableDefaultDotBracket.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableDefaultDotBracket.validate(new ImmutableDefaultDotBracket(newValue, this.sequence, this.structure));
    }

    public final ImmutableDefaultDotBracket withStrands(Iterable<? extends Strand> elements) {
        if (this.strands == elements) {
            return this;
        }
        List<Strand> newValue = ImmutableDefaultDotBracket.createUnmodifiableList(false, ImmutableDefaultDotBracket.createSafeList(elements, true, false));
        return ImmutableDefaultDotBracket.validate(new ImmutableDefaultDotBracket(newValue, this.sequence, this.structure));
    }

    public final ImmutableDefaultDotBracket withSequence(String value) {
        String newValue = Objects.requireNonNull(value, "sequence");
        if (this.sequence.equals(newValue)) {
            return this;
        }
        return ImmutableDefaultDotBracket.validate(new ImmutableDefaultDotBracket(this.strands, newValue, this.structure));
    }

    public final ImmutableDefaultDotBracket withStructure(String value) {
        String newValue = Objects.requireNonNull(value, "structure");
        if (this.structure.equals(newValue)) {
            return this;
        }
        return ImmutableDefaultDotBracket.validate(new ImmutableDefaultDotBracket(this.strands, this.sequence, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultDotBracket && this.equalTo((ImmutableDefaultDotBracket)another);
    }

    private boolean equalTo(ImmutableDefaultDotBracket another) {
        return this.sequence.equals(another.sequence) && this.structure.equals(another.structure);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sequence.hashCode();
        h += (h << 5) + this.structure.hashCode();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<DotBracketSymbol, DotBracketSymbol> pairs() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableDefaultDotBracket immutableDefaultDotBracket = this;
            synchronized (immutableDefaultDotBracket) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.pairs = Objects.requireNonNull(super.pairs(), "pairs");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.pairs;
    }

    public static ImmutableDefaultDotBracket of(String sequence, String structure) {
        return ImmutableDefaultDotBracket.validate(new ImmutableDefaultDotBracket(sequence, structure));
    }

    private static ImmutableDefaultDotBracket validate(ImmutableDefaultDotBracket instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableDefaultDotBracket copyOf(DefaultDotBracket instance) {
        if (instance instanceof ImmutableDefaultDotBracket) {
            return (ImmutableDefaultDotBracket)instance;
        }
        return ImmutableDefaultDotBracket.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableDefaultDotBracket.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="DefaultDotBracket", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SEQUENCE = 1L;
        private static final long INIT_BIT_STRUCTURE = 2L;
        private static final long OPT_BIT_STRANDS = 1L;
        private long initBits = 3L;
        private long optBits;
        private List<Strand> strands = new ArrayList<Strand>();
        @Nullable
        private String sequence;
        @Nullable
        private String structure;

        private Builder() {
        }

        public final Builder from(DefaultDotBracket instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DotBracket instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DotBracket instance;
            long bits = 0L;
            if (object instanceof DefaultDotBracket) {
                instance = (DefaultDotBracket)object;
                if ((bits & 1L) == 0L) {
                    this.sequence(((DefaultDotBracket)instance).sequence());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.structure(((DefaultDotBracket)instance).structure());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllStrands(((DefaultDotBracket)instance).strands());
                    bits |= 4L;
                }
            }
            if (object instanceof DotBracket) {
                instance = (DotBracket)object;
                if ((bits & 1L) == 0L) {
                    this.sequence(instance.sequence());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.structure(instance.structure());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllStrands(instance.strands());
                    bits |= 4L;
                }
            }
        }

        public final Builder addStrands(Strand element) {
            this.strands.add(Objects.requireNonNull(element, "strands element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addStrands(Strand ... elements) {
            for (Strand element : elements) {
                this.strands.add(Objects.requireNonNull(element, "strands element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder strands(Iterable<? extends Strand> elements) {
            this.strands.clear();
            return this.addAllStrands(elements);
        }

        public final Builder addAllStrands(Iterable<? extends Strand> elements) {
            for (Strand strand : elements) {
                this.strands.add(Objects.requireNonNull(strand, "strands element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder sequence(String sequence) {
            this.sequence = Objects.requireNonNull(sequence, "sequence");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder structure(String structure) {
            this.structure = Objects.requireNonNull(structure, "structure");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDefaultDotBracket build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableDefaultDotBracket.validate(new ImmutableDefaultDotBracket(this));
        }

        private boolean strandsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sequence");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("structure");
            }
            return "Cannot build DefaultDotBracket, some of required attributes are not set " + attributes;
        }
    }
}

