/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.formats.Ct;

@ParametersAreNonnullByDefault
@Generated(from="Ct", generator="Immutables")
@Immutable
public final class ImmutableCt
extends Ct {
    private final SortedSet<Ct.ExtendedEntry> entries;

    private ImmutableCt(Iterable<? extends Ct.ExtendedEntry> entries) {
        this.entries = ImmutableCt.createUnmodifiableSortedSet(false, ImmutableCt.createSafeList(entries, true, false));
    }

    private ImmutableCt(ImmutableCt original, SortedSet<Ct.ExtendedEntry> entries) {
        this.entries = entries;
    }

    @Override
    public SortedSet<Ct.ExtendedEntry> entries() {
        return this.entries;
    }

    public final ImmutableCt withEntries(Ct.ExtendedEntry ... elements) {
        NavigableSet<Ct.ExtendedEntry> newValue = ImmutableCt.createUnmodifiableSortedSet(false, ImmutableCt.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableCt.validate(new ImmutableCt(this, newValue));
    }

    public final ImmutableCt withEntries(Iterable<? extends Ct.ExtendedEntry> elements) {
        if (this.entries == elements) {
            return this;
        }
        NavigableSet<Ct.ExtendedEntry> newValue = ImmutableCt.createUnmodifiableSortedSet(false, ImmutableCt.createSafeList(elements, true, false));
        return ImmutableCt.validate(new ImmutableCt(this, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCt && this.equalTo((ImmutableCt)another);
    }

    private boolean equalTo(ImmutableCt another) {
        return this.entries.equals(another.entries);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.entries.hashCode();
        return h;
    }

    public static ImmutableCt of(SortedSet<Ct.ExtendedEntry> entries) {
        return ImmutableCt.of(entries);
    }

    public static ImmutableCt of(Iterable<? extends Ct.ExtendedEntry> entries) {
        return ImmutableCt.validate(new ImmutableCt(entries));
    }

    private static ImmutableCt validate(ImmutableCt instance) {
        instance = (ImmutableCt)instance.validate();
        return instance;
    }

    public static ImmutableCt copyOf(Ct instance) {
        if (instance instanceof ImmutableCt) {
            return (ImmutableCt)instance;
        }
        return ImmutableCt.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableCt.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T extends Comparable<T>> NavigableSet<T> createUnmodifiableSortedSet(boolean reverse, List<T> list) {
        TreeSet set = reverse ? new TreeSet(Collections.reverseOrder()) : new TreeSet();
        set.addAll(list);
        return Collections.unmodifiableNavigableSet(set);
    }

    @Generated(from="Ct", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<Ct.ExtendedEntry> entries = new ArrayList<Ct.ExtendedEntry>();

        private Builder() {
        }

        public final Builder from(Ct instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllEntries(instance.entries());
            return this;
        }

        public final Builder addEntries(Ct.ExtendedEntry element) {
            this.entries.add(Objects.requireNonNull(element, "entries element"));
            return this;
        }

        public final Builder addEntries(Ct.ExtendedEntry ... elements) {
            for (Ct.ExtendedEntry element : elements) {
                this.entries.add(Objects.requireNonNull(element, "entries element"));
            }
            return this;
        }

        public final Builder entries(Iterable<? extends Ct.ExtendedEntry> elements) {
            this.entries.clear();
            return this.addAllEntries(elements);
        }

        public final Builder addAllEntries(Iterable<? extends Ct.ExtendedEntry> elements) {
            for (Ct.ExtendedEntry extendedEntry : elements) {
                this.entries.add(Objects.requireNonNull(extendedEntry, "entries element"));
            }
            return this;
        }

        public ImmutableCt build() {
            return ImmutableCt.validate(new ImmutableCt(null, ImmutableCt.createUnmodifiableSortedSet(false, ImmutableCt.createSafeList(this.entries, false, false))));
        }
    }
}

