/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.collections4.BidiMap;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.formats.AbstractCombinedStrand;
import pl.poznan.put.structure.formats.CombinedStrandFromPdb;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.Strand;

@ParametersAreNonnullByDefault
@Generated(from="CombinedStrandFromPdb", generator="Immutables")
@Immutable
public final class ImmutableCombinedStrandFromPdb
extends CombinedStrandFromPdb {
    private final List<DotBracket> combineStrands;
    private final List<Strand> inputStrands;
    private final Map<DotBracketSymbol, PdbResidueIdentifier> inputSymbolToResidue;
    private volatile transient long lazyInitBitmap;
    private static final long SYMBOLS_LAZY_INIT_BIT = 1L;
    private transient List<DotBracketSymbol> symbols;
    private static final long STRANDS_LAZY_INIT_BIT = 2L;
    private transient List<Strand> strands;
    private static final long PAIRS_LAZY_INIT_BIT = 4L;
    private transient Map<DotBracketSymbol, DotBracketSymbol> pairs;
    private static final long SYMBOL_TO_RESIDUE_LAZY_INIT_BIT = 8L;
    private transient Map<DotBracketSymbol, PdbResidueIdentifier> symbolToResidue;
    private static final long MAPPING_LAZY_INIT_BIT = 16L;
    private transient BidiMap<DotBracketSymbol, PdbResidueIdentifier> mapping;

    private ImmutableCombinedStrandFromPdb(Iterable<? extends Strand> inputStrands, Map<? extends DotBracketSymbol, ? extends PdbResidueIdentifier> inputSymbolToResidue) {
        this.inputStrands = ImmutableCombinedStrandFromPdb.createUnmodifiableList(false, ImmutableCombinedStrandFromPdb.createSafeList(inputStrands, true, false));
        this.inputSymbolToResidue = ImmutableCombinedStrandFromPdb.createUnmodifiableMap(true, false, inputSymbolToResidue);
        this.combineStrands = Collections.emptyList();
    }

    private ImmutableCombinedStrandFromPdb(List<DotBracket> combineStrands, List<Strand> inputStrands, Map<DotBracketSymbol, PdbResidueIdentifier> inputSymbolToResidue) {
        this.combineStrands = combineStrands;
        this.inputStrands = inputStrands;
        this.inputSymbolToResidue = inputSymbolToResidue;
    }

    @Override
    public List<DotBracket> combineStrands() {
        return this.combineStrands;
    }

    @Override
    protected List<Strand> inputStrands() {
        return this.inputStrands;
    }

    @Override
    protected Map<DotBracketSymbol, PdbResidueIdentifier> inputSymbolToResidue() {
        return this.inputSymbolToResidue;
    }

    public final ImmutableCombinedStrandFromPdb withCombineStrands(DotBracket ... elements) {
        List<DotBracket> newValue = ImmutableCombinedStrandFromPdb.createUnmodifiableList(false, ImmutableCombinedStrandFromPdb.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCombinedStrandFromPdb(newValue, this.inputStrands, this.inputSymbolToResidue);
    }

    public final ImmutableCombinedStrandFromPdb withCombineStrands(Iterable<? extends DotBracket> elements) {
        if (this.combineStrands == elements) {
            return this;
        }
        List<DotBracket> newValue = ImmutableCombinedStrandFromPdb.createUnmodifiableList(false, ImmutableCombinedStrandFromPdb.createSafeList(elements, true, false));
        return new ImmutableCombinedStrandFromPdb(newValue, this.inputStrands, this.inputSymbolToResidue);
    }

    public final ImmutableCombinedStrandFromPdb withInputStrands(Strand ... elements) {
        List<Strand> newValue = ImmutableCombinedStrandFromPdb.createUnmodifiableList(false, ImmutableCombinedStrandFromPdb.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCombinedStrandFromPdb(this.combineStrands, newValue, this.inputSymbolToResidue);
    }

    public final ImmutableCombinedStrandFromPdb withInputStrands(Iterable<? extends Strand> elements) {
        if (this.inputStrands == elements) {
            return this;
        }
        List<Strand> newValue = ImmutableCombinedStrandFromPdb.createUnmodifiableList(false, ImmutableCombinedStrandFromPdb.createSafeList(elements, true, false));
        return new ImmutableCombinedStrandFromPdb(this.combineStrands, newValue, this.inputSymbolToResidue);
    }

    public final ImmutableCombinedStrandFromPdb withInputSymbolToResidue(Map<? extends DotBracketSymbol, ? extends PdbResidueIdentifier> entries) {
        if (this.inputSymbolToResidue == entries) {
            return this;
        }
        Map<DotBracketSymbol, PdbResidueIdentifier> newValue = ImmutableCombinedStrandFromPdb.createUnmodifiableMap(true, false, entries);
        return new ImmutableCombinedStrandFromPdb(this.combineStrands, this.inputStrands, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCombinedStrandFromPdb && this.equalTo((ImmutableCombinedStrandFromPdb)another);
    }

    private boolean equalTo(ImmutableCombinedStrandFromPdb another) {
        return this.combineStrands.equals(another.combineStrands) && this.inputStrands.equals(another.inputStrands) && this.inputSymbolToResidue.equals(another.inputSymbolToResidue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.combineStrands.hashCode();
        h += (h << 5) + this.inputStrands.hashCode();
        h += (h << 5) + this.inputSymbolToResidue.hashCode();
        return h;
    }

    public String toString() {
        return "CombinedStrandFromPdb{combineStrands=" + this.combineStrands + ", inputStrands=" + this.inputStrands + ", inputSymbolToResidue=" + this.inputSymbolToResidue + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DotBracketSymbol> symbols() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableCombinedStrandFromPdb immutableCombinedStrandFromPdb = this;
            synchronized (immutableCombinedStrandFromPdb) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.symbols = Objects.requireNonNull(super.symbols(), "symbols");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.symbols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Strand> strands() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableCombinedStrandFromPdb immutableCombinedStrandFromPdb = this;
            synchronized (immutableCombinedStrandFromPdb) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.strands = Objects.requireNonNull(super.strands(), "strands");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.strands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<DotBracketSymbol, DotBracketSymbol> pairs() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableCombinedStrandFromPdb immutableCombinedStrandFromPdb = this;
            synchronized (immutableCombinedStrandFromPdb) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.pairs = Objects.requireNonNull(super.pairs(), "pairs");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.pairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<DotBracketSymbol, PdbResidueIdentifier> symbolToResidue() {
        if ((this.lazyInitBitmap & 8L) == 0L) {
            ImmutableCombinedStrandFromPdb immutableCombinedStrandFromPdb = this;
            synchronized (immutableCombinedStrandFromPdb) {
                if ((this.lazyInitBitmap & 8L) == 0L) {
                    this.symbolToResidue = Objects.requireNonNull(super.symbolToResidue(), "symbolToResidue");
                    this.lazyInitBitmap |= 8L;
                }
            }
        }
        return this.symbolToResidue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BidiMap<DotBracketSymbol, PdbResidueIdentifier> mapping() {
        if ((this.lazyInitBitmap & 0x10L) == 0L) {
            ImmutableCombinedStrandFromPdb immutableCombinedStrandFromPdb = this;
            synchronized (immutableCombinedStrandFromPdb) {
                if ((this.lazyInitBitmap & 0x10L) == 0L) {
                    this.mapping = Objects.requireNonNull(super.mapping(), "mapping");
                    this.lazyInitBitmap |= 0x10L;
                }
            }
        }
        return this.mapping;
    }

    public static ImmutableCombinedStrandFromPdb of(List<Strand> inputStrands, Map<DotBracketSymbol, PdbResidueIdentifier> inputSymbolToResidue) {
        return ImmutableCombinedStrandFromPdb.of(inputStrands, inputSymbolToResidue);
    }

    public static ImmutableCombinedStrandFromPdb of(Iterable<? extends Strand> inputStrands, Map<? extends DotBracketSymbol, ? extends PdbResidueIdentifier> inputSymbolToResidue) {
        return new ImmutableCombinedStrandFromPdb(inputStrands, inputSymbolToResidue);
    }

    public static ImmutableCombinedStrandFromPdb copyOf(CombinedStrandFromPdb instance) {
        if (instance instanceof ImmutableCombinedStrandFromPdb) {
            return (ImmutableCombinedStrandFromPdb)instance;
        }
        return ImmutableCombinedStrandFromPdb.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="CombinedStrandFromPdb", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<DotBracket> combineStrands = new ArrayList<DotBracket>();
        private List<Strand> inputStrands = new ArrayList<Strand>();
        private Map<DotBracketSymbol, PdbResidueIdentifier> inputSymbolToResidue = new LinkedHashMap<DotBracketSymbol, PdbResidueIdentifier>();

        private Builder() {
        }

        public final Builder from(CombinedStrandFromPdb instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractCombinedStrand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DotBracket instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DotBracket instance;
            long bits = 0L;
            if (object instanceof CombinedStrandFromPdb) {
                instance = (CombinedStrandFromPdb)object;
                this.putAllInputSymbolToResidue(((CombinedStrandFromPdb)instance).inputSymbolToResidue());
                if ((bits & 1L) == 0L) {
                    this.addAllInputStrands(((CombinedStrandFromPdb)instance).inputStrands());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractCombinedStrand) {
                instance = (AbstractCombinedStrand)object;
                if ((bits & 1L) == 0L) {
                    this.addAllInputStrands(((AbstractCombinedStrand)instance).inputStrands());
                    bits |= 1L;
                }
            }
            if (object instanceof DotBracket) {
                instance = (DotBracket)object;
                this.addAllCombineStrands(instance.combineStrands());
            }
        }

        public final Builder addCombineStrands(DotBracket element) {
            this.combineStrands.add(Objects.requireNonNull(element, "combineStrands element"));
            return this;
        }

        public final Builder addCombineStrands(DotBracket ... elements) {
            for (DotBracket element : elements) {
                this.combineStrands.add(Objects.requireNonNull(element, "combineStrands element"));
            }
            return this;
        }

        public final Builder combineStrands(Iterable<? extends DotBracket> elements) {
            this.combineStrands.clear();
            return this.addAllCombineStrands(elements);
        }

        public final Builder addAllCombineStrands(Iterable<? extends DotBracket> elements) {
            for (DotBracket dotBracket : elements) {
                this.combineStrands.add(Objects.requireNonNull(dotBracket, "combineStrands element"));
            }
            return this;
        }

        public final Builder addInputStrands(Strand element) {
            this.inputStrands.add(Objects.requireNonNull(element, "inputStrands element"));
            return this;
        }

        public final Builder addInputStrands(Strand ... elements) {
            for (Strand element : elements) {
                this.inputStrands.add(Objects.requireNonNull(element, "inputStrands element"));
            }
            return this;
        }

        public final Builder inputStrands(Iterable<? extends Strand> elements) {
            this.inputStrands.clear();
            return this.addAllInputStrands(elements);
        }

        public final Builder addAllInputStrands(Iterable<? extends Strand> elements) {
            for (Strand strand : elements) {
                this.inputStrands.add(Objects.requireNonNull(strand, "inputStrands element"));
            }
            return this;
        }

        public final Builder putInputSymbolToResidue(DotBracketSymbol key, PdbResidueIdentifier value) {
            this.inputSymbolToResidue.put(Objects.requireNonNull(key, "inputSymbolToResidue key"), Objects.requireNonNull(value, "inputSymbolToResidue value"));
            return this;
        }

        public final Builder putInputSymbolToResidue(Map.Entry<? extends DotBracketSymbol, ? extends PdbResidueIdentifier> entry) {
            DotBracketSymbol k = entry.getKey();
            PdbResidueIdentifier v = entry.getValue();
            this.inputSymbolToResidue.put(Objects.requireNonNull(k, "inputSymbolToResidue key"), Objects.requireNonNull(v, "inputSymbolToResidue value"));
            return this;
        }

        public final Builder inputSymbolToResidue(Map<? extends DotBracketSymbol, ? extends PdbResidueIdentifier> entries) {
            this.inputSymbolToResidue.clear();
            return this.putAllInputSymbolToResidue(entries);
        }

        public final Builder putAllInputSymbolToResidue(Map<? extends DotBracketSymbol, ? extends PdbResidueIdentifier> entries) {
            for (Map.Entry<? extends DotBracketSymbol, ? extends PdbResidueIdentifier> e : entries.entrySet()) {
                DotBracketSymbol k = e.getKey();
                PdbResidueIdentifier v = e.getValue();
                this.inputSymbolToResidue.put(Objects.requireNonNull(k, "inputSymbolToResidue key"), Objects.requireNonNull(v, "inputSymbolToResidue value"));
            }
            return this;
        }

        public ImmutableCombinedStrandFromPdb build() {
            return new ImmutableCombinedStrandFromPdb(ImmutableCombinedStrandFromPdb.createUnmodifiableList(true, this.combineStrands), ImmutableCombinedStrandFromPdb.createUnmodifiableList(true, this.inputStrands), ImmutableCombinedStrandFromPdb.createUnmodifiableMap(false, false, this.inputSymbolToResidue));
        }
    }
}

