/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.formats.AbstractCombinedStrand;
import pl.poznan.put.structure.formats.CombinedStrand;
import pl.poznan.put.structure.formats.Strand;

@ParametersAreNonnullByDefault
@Generated(from="CombinedStrand", generator="Immutables")
@Immutable
public final class ImmutableCombinedStrand
extends CombinedStrand {
    private final List<Strand> inputStrands;
    private volatile transient long lazyInitBitmap;
    private static final long SYMBOLS_LAZY_INIT_BIT = 1L;
    private transient List<DotBracketSymbol> symbols;
    private static final long STRANDS_LAZY_INIT_BIT = 2L;
    private transient List<Strand> strands;
    private static final long PAIRS_LAZY_INIT_BIT = 4L;
    private transient Map<DotBracketSymbol, DotBracketSymbol> pairs;

    private ImmutableCombinedStrand(Iterable<? extends Strand> inputStrands) {
        this.inputStrands = ImmutableCombinedStrand.createUnmodifiableList(false, ImmutableCombinedStrand.createSafeList(inputStrands, true, false));
    }

    private ImmutableCombinedStrand(ImmutableCombinedStrand original, List<Strand> inputStrands) {
        this.inputStrands = inputStrands;
    }

    @Override
    protected List<Strand> inputStrands() {
        return this.inputStrands;
    }

    public final ImmutableCombinedStrand withInputStrands(Strand ... elements) {
        List<Strand> newValue = ImmutableCombinedStrand.createUnmodifiableList(false, ImmutableCombinedStrand.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCombinedStrand(this, newValue);
    }

    public final ImmutableCombinedStrand withInputStrands(Iterable<? extends Strand> elements) {
        if (this.inputStrands == elements) {
            return this;
        }
        List<Strand> newValue = ImmutableCombinedStrand.createUnmodifiableList(false, ImmutableCombinedStrand.createSafeList(elements, true, false));
        return new ImmutableCombinedStrand(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCombinedStrand && this.equalTo((ImmutableCombinedStrand)another);
    }

    private boolean equalTo(ImmutableCombinedStrand another) {
        return this.inputStrands.equals(another.inputStrands);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.inputStrands.hashCode();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DotBracketSymbol> symbols() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableCombinedStrand immutableCombinedStrand = this;
            synchronized (immutableCombinedStrand) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.symbols = Objects.requireNonNull(super.symbols(), "symbols");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.symbols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Strand> strands() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableCombinedStrand immutableCombinedStrand = this;
            synchronized (immutableCombinedStrand) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.strands = Objects.requireNonNull(super.strands(), "strands");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.strands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<DotBracketSymbol, DotBracketSymbol> pairs() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableCombinedStrand immutableCombinedStrand = this;
            synchronized (immutableCombinedStrand) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.pairs = Objects.requireNonNull(super.pairs(), "pairs");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.pairs;
    }

    public static ImmutableCombinedStrand of(List<Strand> inputStrands) {
        return ImmutableCombinedStrand.of(inputStrands);
    }

    public static ImmutableCombinedStrand of(Iterable<? extends Strand> inputStrands) {
        return new ImmutableCombinedStrand(inputStrands);
    }

    public static ImmutableCombinedStrand copyOf(CombinedStrand instance) {
        if (instance instanceof ImmutableCombinedStrand) {
            return (ImmutableCombinedStrand)instance;
        }
        return ImmutableCombinedStrand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CombinedStrand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<Strand> inputStrands = new ArrayList<Strand>();

        private Builder() {
        }

        public final Builder from(AbstractCombinedStrand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CombinedStrand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractCombinedStrand instance;
            long bits = 0L;
            if (object instanceof AbstractCombinedStrand) {
                instance = (AbstractCombinedStrand)object;
                if ((bits & 1L) == 0L) {
                    this.addAllInputStrands(instance.inputStrands());
                    bits |= 1L;
                }
            }
            if (object instanceof CombinedStrand) {
                instance = (CombinedStrand)object;
                if ((bits & 1L) == 0L) {
                    this.addAllInputStrands(((CombinedStrand)instance).inputStrands());
                    bits |= 1L;
                }
            }
        }

        public final Builder addInputStrands(Strand element) {
            this.inputStrands.add(Objects.requireNonNull(element, "inputStrands element"));
            return this;
        }

        public final Builder addInputStrands(Strand ... elements) {
            for (Strand element : elements) {
                this.inputStrands.add(Objects.requireNonNull(element, "inputStrands element"));
            }
            return this;
        }

        public final Builder inputStrands(Iterable<? extends Strand> elements) {
            this.inputStrands.clear();
            return this.addAllInputStrands(elements);
        }

        public final Builder addAllInputStrands(Iterable<? extends Strand> elements) {
            for (Strand strand : elements) {
                this.inputStrands.add(Objects.requireNonNull(strand, "inputStrands element"));
            }
            return this;
        }

        public ImmutableCombinedStrand build() {
            return new ImmutableCombinedStrand(null, ImmutableCombinedStrand.createUnmodifiableList(true, this.inputStrands));
        }
    }
}

