/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.formats.ImmutableStrandView;
import pl.poznan.put.structure.formats.Strand;
import pl.poznan.put.structure.formats.TerminalMissing;

public interface DotBracket {
    public List<DotBracketSymbol> symbols();

    public List<DotBracket> combineStrands();

    default public int originalIndex(DotBracketSymbol symbol) {
        return symbol.index() + 1;
    }

    default public List<Strand> strands() {
        return Collections.singletonList(ImmutableStrandView.of("", this, 0, this.structure().length()));
    }

    default public String sequence() {
        return this.symbols().stream().map(DotBracketSymbol::sequence).map(c -> Character.toString(c.charValue())).collect(Collectors.joining());
    }

    default public String structure() {
        return this.symbols().stream().map(DotBracketSymbol::structure).map(c -> Character.toString(c.charValue())).collect(Collectors.joining());
    }

    default public Map<DotBracketSymbol, DotBracketSymbol> pairs() {
        String opening = "([{<ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String closing = ")]}>abcdefghijklmnopqrstuvwxyz";
        DualHashBidiMap parentheses = new DualHashBidiMap(IntStream.range(0, "([{<ABCDEFGHIJKLMNOPQRSTUVWXYZ".length()).boxed().collect(Collectors.toMap("([{<ABCDEFGHIJKLMNOPQRSTUVWXYZ"::charAt, ")]}>abcdefghijklmnopqrstuvwxyz"::charAt)));
        Map parenthesesStacks = parentheses.keySet().stream().collect(Collectors.toMap(Function.identity(), ignored -> new ArrayDeque()));
        HashMap<DotBracketSymbol, DotBracketSymbol> result = new HashMap<DotBracketSymbol, DotBracketSymbol>();
        for (DotBracketSymbol symbol : this.symbols()) {
            char structure = symbol.structure();
            if (parentheses.containsKey((Object)Character.valueOf(structure))) {
                parenthesesStacks.get(Character.valueOf(structure)).push(symbol);
                continue;
            }
            if (!parentheses.containsValue((Object)Character.valueOf(structure))) continue;
            DotBracketSymbol pair = (DotBracketSymbol)parenthesesStacks.get(parentheses.getKey((Object)Character.valueOf(structure))).pop();
            result.put(symbol, pair);
            result.put(pair, symbol);
        }
        return result;
    }

    default public String toStringWithStrands() {
        return this.strands().stream().map(String::valueOf).collect(Collectors.joining("\n"));
    }

    default public int length() {
        return this.symbols().size();
    }

    default public boolean containsMissing() {
        return this.symbols().stream().anyMatch(DotBracketSymbol::isMissing);
    }

    default public List<TerminalMissing> missingTerminal() {
        return this.strands().stream().flatMap(strand -> Stream.of(strand.missingBegin(), strand.missingEnd())).collect(Collectors.toList());
    }

    default public List<DotBracketSymbol> missingInternal() {
        Set missingTerminal = this.missingTerminal().stream().map(TerminalMissing::symbols).flatMap(Collection::stream).collect(Collectors.toSet());
        return this.strands().stream().flatMap(strand -> strand.symbols().stream()).filter(DotBracketSymbol::isMissing).filter(dotBracketSymbol -> !missingTerminal.contains(dotBracketSymbol)).collect(Collectors.toList());
    }

    default public int pseudoknotOrder() {
        return this.symbols().stream().map(DotBracketSymbol::order).max(Comparator.naturalOrder()).orElse(0);
    }

    default public Strand findStrand(DotBracketSymbol symbol) {
        return this.strands().stream().filter(strand -> strand.symbols().contains(symbol)).findFirst().orElseThrow(() -> new IllegalArgumentException("Failed to find strand containing symbol: " + symbol));
    }

    default public String sequence(boolean separateStrands) {
        StringBuilder builder = new StringBuilder();
        for (Strand strand : this.strands()) {
            builder.append(strand.sequence());
            if (!separateStrands) continue;
            builder.append('&');
        }
        return builder.toString();
    }

    default public String structure(boolean separateStrands) {
        StringBuilder builder = new StringBuilder();
        for (Strand strand : this.strands()) {
            builder.append(strand.structure());
            if (!separateStrands) continue;
            builder.append('&');
        }
        return builder.toString();
    }
}

