/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.Validate;
import org.immutables.value.Value;
import pl.poznan.put.pdb.PdbNamedResidueIdentifier;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.pdb.analysis.PdbChain;
import pl.poznan.put.pdb.analysis.PdbModel;
import pl.poznan.put.structure.ClassifiedBasePair;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.formats.AbstractDotBracket;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.DotBracketFromPdb;
import pl.poznan.put.structure.formats.ImmutableCombinedStrandFromPdb;
import pl.poznan.put.structure.formats.ImmutableDefaultDotBracketFromPdb;
import pl.poznan.put.structure.formats.ImmutableStrandView;
import pl.poznan.put.structure.formats.Strand;

@Value.Immutable
public abstract class DefaultDotBracketFromPdb
extends AbstractDotBracket
implements DotBracketFromPdb {
    private static void depthFirstSearch(Strand u, Map<Strand, Set<Strand>> graph, Set<Strand> visited, Set<Strand> component) {
        visited.add(u);
        component.add(u);
        for (Strand v : graph.getOrDefault(u, Collections.emptySet())) {
            if (visited.contains(v)) continue;
            DefaultDotBracketFromPdb.depthFirstSearch(v, graph, visited, component);
        }
    }

    @Value.Parameter(order=3)
    public abstract PdbModel model();

    @Override
    public final List<DotBracket> combineStrands() {
        return this.candidatesToCombine().stream().map(strands -> ImmutableCombinedStrandFromPdb.of(strands, this.symbolToResidue())).collect(Collectors.toList());
    }

    @Override
    public final int originalIndex(DotBracketSymbol symbol) {
        return this.symbolToResidue().get(symbol).residueNumber();
    }

    @Override
    @Value.Default
    @Value.Auxiliary
    public List<Strand> strands() {
        ArrayList<Strand> strands = new ArrayList<Strand>();
        int start = 0;
        int end = 0;
        for (PdbChain chain : this.model().chains()) {
            strands.add(ImmutableStrandView.of(chain.identifier(), this, start, end += chain.residues().size()));
            start = end;
        }
        return strands;
    }

    @Override
    @Value.Parameter(order=1)
    public abstract String sequence();

    @Override
    @Value.Parameter(order=2)
    public abstract String structure();

    @Override
    @Value.Lazy
    @Value.Auxiliary
    public Map<DotBracketSymbol, DotBracketSymbol> pairs() {
        return super.pairs();
    }

    @Override
    public final PdbResidueIdentifier identifier(DotBracketSymbol symbol) {
        return this.symbolToResidue().get(symbol);
    }

    @Override
    public final DotBracketSymbol symbol(PdbResidueIdentifier residueIdentifier) {
        return this.residueToSymbol().get(residueIdentifier);
    }

    @Override
    public final boolean contains(PdbResidueIdentifier residueIdentifier) {
        return this.residueToSymbol().containsKey(residueIdentifier);
    }

    @Override
    public final List<DotBracketFromPdb> combineStrands(List<ClassifiedBasePair> nonCanonical) {
        LinkedHashMap<Strand, Set<Strand>> strandMap = new LinkedHashMap<Strand, Set<Strand>>();
        this.strands().forEach(strand -> this.pairs().keySet().stream().filter(symbol -> strand.symbols().contains(symbol)).forEach(symbol -> this.linkStrands((Strand)strand, this.pairs().get(symbol), (Map<Strand, Set<Strand>>)strandMap)));
        for (ClassifiedBasePair nonCanonicalPair : nonCanonical) {
            PdbNamedResidueIdentifier l = nonCanonicalPair.basePair().left();
            PdbNamedResidueIdentifier r = nonCanonicalPair.basePair().right();
            DotBracketSymbol dotBracketSymbol = this.residueToSymbol().get(PdbResidueIdentifier.from(l));
            DotBracketSymbol right = this.residueToSymbol().get(PdbResidueIdentifier.from(r));
            for (Strand strand2 : this.strands()) {
                List<DotBracketSymbol> strandSymbols = strand2.symbols();
                if (!strandSymbols.contains(dotBracketSymbol) || strandSymbols.contains(right)) continue;
                this.linkStrands(strand2, right, strandMap);
            }
        }
        HashSet<Strand> visited = new HashSet<Strand>(this.strands().size());
        ArrayList<HashSet<Strand>> components = new ArrayList<HashSet<Strand>>();
        for (Strand strand3 : this.strands()) {
            if (visited.contains(strand3)) continue;
            HashSet<Strand> hashSet = new HashSet<Strand>();
            DefaultDotBracketFromPdb.depthFirstSearch(strand3, strandMap, visited, hashSet);
            components.add(hashSet);
        }
        ArrayList<DotBracketFromPdb> result = new ArrayList<DotBracketFromPdb>(components.size());
        for (Set set : components) {
            List<Strand> combinedStrands = set.stream().sorted(Comparator.comparingInt(this.strands()::indexOf)).collect(Collectors.toList());
            result.add(ImmutableCombinedStrandFromPdb.of(combinedStrands, this.symbolToResidue()));
        }
        return result;
    }

    @Value.Lazy
    protected Map<PdbResidueIdentifier, DotBracketSymbol> residueToSymbol() {
        return IntStream.range(0, this.symbols().size()).boxed().collect(Collectors.toMap(i -> this.model().residues().get((int)i).identifier(), i -> (DotBracketSymbol)this.symbols().get((int)i)));
    }

    @Value.Lazy
    protected Map<DotBracketSymbol, PdbResidueIdentifier> symbolToResidue() {
        return IntStream.range(0, this.symbols().size()).boxed().collect(Collectors.toMap(i -> (DotBracketSymbol)this.symbols().get((int)i), i -> this.model().residues().get((int)i).identifier()));
    }

    @Value.Check
    protected DefaultDotBracketFromPdb validate() {
        Validate.matchesPattern((CharSequence)this.sequence(), (String)"[ACGUTRYNacgutryn]+");
        Validate.matchesPattern((CharSequence)this.structure(), (String)"[-.()\\[\\]{}<>A-Za-z]+");
        Validate.isTrue((this.sequence().length() == this.structure().length() ? 1 : 0) != 0, (String)"Sequence and structure must be of the same length", (Object[])new Object[0]);
        List<Integer> positionsToModify = IntStream.range(0, this.model().residues().size()).filter(i -> this.model().residues().get(i).isMissing() && this.structure().charAt(i) != '-').boxed().collect(Collectors.toList());
        if (positionsToModify.isEmpty()) {
            return this;
        }
        char[] chars = this.structure().toCharArray();
        positionsToModify.forEach(i -> {
            chars[i.intValue()] = 45;
        });
        return ImmutableDefaultDotBracketFromPdb.of(this.sequence(), String.valueOf(chars), this.model());
    }

    private void linkStrands(Strand firstStrand, DotBracketSymbol symbolInSecondStrand, Map<Strand, Set<Strand>> strandMap) {
        for (Strand secondStrand : this.strands()) {
            if (secondStrand.equals(firstStrand) || !secondStrand.symbols().contains(symbolInSecondStrand)) continue;
            if (!strandMap.containsKey(firstStrand)) {
                strandMap.put(firstStrand, new LinkedHashSet());
            }
            strandMap.get(firstStrand).add(secondStrand);
            if (!strandMap.containsKey(secondStrand)) {
                strandMap.put(secondStrand, new LinkedHashSet());
            }
            strandMap.get(secondStrand).add(firstStrand);
            return;
        }
    }
}

