/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.immutables.value.Value;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.formats.AbstractDotBracket;
import pl.poznan.put.structure.formats.Ct;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.ImmutableCombinedStrand;
import pl.poznan.put.structure.formats.ImmutableDefaultDotBracket;
import pl.poznan.put.structure.formats.ImmutableStrandView;
import pl.poznan.put.structure.formats.Strand;

@Value.Immutable
public abstract class DefaultDotBracket
extends AbstractDotBracket
implements Serializable {
    static final String SEQUENCE_PATTERN = "[ACGUTRYNacgutryn]+";
    static final String STRUCTURE_PATTERN = "[-.()\\[\\]{}<>A-Za-z]+";
    private static final Pattern DOTBRACKET_PATTERN = Pattern.compile("(>.+\\r?\\n)?([ACGUTRYNacgutryn]+)\\r?\\n([-.()\\[\\]{}<>A-Za-z]+)");

    public static DotBracket copyWithStrands(DotBracket input, Ct ct) {
        ImmutableDefaultDotBracket dotBracket = input instanceof DefaultDotBracket ? ImmutableDefaultDotBracket.copyOf((DefaultDotBracket)input) : ImmutableDefaultDotBracket.of(input.sequence(), input.structure());
        ArrayList<Ct.ExtendedEntry> entries = new ArrayList<Ct.ExtendedEntry>(ct.entries());
        List ends = IntStream.range(0, entries.size()).filter(i -> ((Ct.ExtendedEntry)entries.get(i)).after() == 0).boxed().collect(Collectors.toList());
        List strands = IntStream.range(1, ends.size()).mapToObj(i -> ImmutableStrandView.of("", dotBracket, (Integer)ends.get(i - 1) + 1, (Integer)ends.get(i) + 1)).collect(Collectors.toList());
        strands.add(0, ImmutableStrandView.of("", dotBracket, 0, (Integer)ends.get(0) + 1));
        return ImmutableDefaultDotBracket.copyOf(dotBracket).withStrands(strands);
    }

    public static DefaultDotBracket fromString(String data) {
        Matcher matcher = DOTBRACKET_PATTERN.matcher(data);
        ArrayList<Pair> pairBeginEnd = new ArrayList<Pair>();
        ArrayList<String> strandNames = new ArrayList<String>();
        StringBuilder sequenceBuilder = new StringBuilder(data.length());
        StringBuilder structureBuilder = new StringBuilder(data.length());
        int begin = 0;
        int end = 0;
        while (matcher.find()) {
            String strandName = matcher.group(1) != null ? matcher.group(1).substring(1).trim() : "";
            String sequence = matcher.group(2);
            String structure = matcher.group(3);
            if (sequence.length() != structure.length()) {
                throw new IllegalArgumentException("Invalid dot-bracket string:\n" + data);
            }
            strandNames.add(strandName.replaceFirst("strand_", ""));
            sequenceBuilder.append(sequence);
            structureBuilder.append(structure);
            pairBeginEnd.add(Pair.of((Object)begin, (Object)(end += sequence.length())));
            begin = end;
        }
        if (sequenceBuilder.length() == 0 || structureBuilder.length() == 0) {
            throw new IllegalArgumentException("Cannot parse dot-bracket:\n" + data);
        }
        ImmutableDefaultDotBracket dotBracket = ImmutableDefaultDotBracket.of(sequenceBuilder.toString(), structureBuilder.toString());
        ArrayList<ImmutableStrandView> strands = new ArrayList<ImmutableStrandView>();
        int index = 0;
        for (Pair pair : pairBeginEnd) {
            strands.add(ImmutableStrandView.of((String)strandNames.get(index), dotBracket, (Integer)pair.getLeft(), (Integer)pair.getRight()));
            ++index;
        }
        return ImmutableDefaultDotBracket.copyOf(dotBracket).withStrands(strands);
    }

    @Override
    public final List<DotBracket> combineStrands() {
        return this.candidatesToCombine().stream().map(ImmutableCombinedStrand::of).collect(Collectors.toList());
    }

    @Override
    @Value.Auxiliary
    @Value.Default
    public List<Strand> strands() {
        return super.strands();
    }

    @Override
    @Value.Parameter(order=1)
    public abstract String sequence();

    @Override
    @Value.Parameter(order=2)
    public abstract String structure();

    @Override
    @Value.Lazy
    @Value.Auxiliary
    public Map<DotBracketSymbol, DotBracketSymbol> pairs() {
        return super.pairs();
    }

    public final String toString() {
        return ">strand\n" + this.sequence() + '\n' + this.structure();
    }

    @Value.Check
    protected void validate() {
        Validate.matchesPattern((CharSequence)this.sequence(), (String)SEQUENCE_PATTERN);
        Validate.matchesPattern((CharSequence)this.structure(), (String)STRUCTURE_PATTERN);
        Validate.isTrue((this.sequence().length() == this.structure().length() ? 1 : 0) != 0, (String)"Sequence and structure must be of the same length", (Object[])new Object[0]);
    }
}

