/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.immutables.value.Value;
import pl.poznan.put.structure.formats.BpSeq;
import pl.poznan.put.structure.formats.Converter;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.ImmutableDefaultDotBracket;
import pl.poznan.put.structure.formats.ImmutableState;
import pl.poznan.put.structure.pseudoknots.PseudoknotFinder;
import pl.poznan.put.structure.pseudoknots.elimination.ImmutableMinGain;

@Value.Immutable(singleton=true)
public abstract class DefaultConverter
implements Converter {
    private static final char[] BRACKETS_OPENING = "([{<ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] BRACKETS_CLOSING = ")]}>abcdefghijklmnopqrstuvwxyz".toCharArray();

    private static boolean isProcessingNeeded(Iterable<State> states) {
        for (State state : states) {
            if (state.isFinal()) continue;
            return true;
        }
        return false;
    }

    private static String traceback(State state) {
        char[] structure = new char[state.size()];
        Arrays.fill(structure, '.');
        Optional<State> current = state.parent();
        while (current.isPresent()) {
            for (BpSeq.Entry pairs : current.get().bpSeq().paired()) {
                int i = pairs.index();
                int j = pairs.pair();
                if (structure[i - 1] != '.') continue;
                structure[i - 1] = BRACKETS_OPENING[current.get().level()];
                structure[j - 1] = BRACKETS_CLOSING[current.get().level()];
            }
            current = current.get().parent();
        }
        return new String(structure);
    }

    @Value.Default
    public PseudoknotFinder pseudoknotFinder() {
        return ImmutableMinGain.of();
    }

    @Value.Default
    public int maxSolutions() {
        return 1;
    }

    @Override
    public final DotBracket convert(BpSeq bpSeq) {
        List<State> states = new ArrayList<State>();
        states.add(ImmutableState.of(Optional.empty(), bpSeq, 0));
        while (DefaultConverter.isProcessingNeeded(states)) {
            states = this.processStates(states);
        }
        Collections.sort(states);
        String structure = DefaultConverter.traceback((State)states.get(0));
        return ImmutableDefaultDotBracket.of(bpSeq.sequence(), structure);
    }

    private List<State> processStates(Collection<State> states) {
        ArrayList<State> nextStates = new ArrayList<State>(states.size());
        for (State state : states) {
            for (BpSeq bpSeq : this.pseudoknotFinder().findPseudoknots(state.bpSeq())) {
                ImmutableState nextState = ImmutableState.of(Optional.of(state), bpSeq, state.level() + 1);
                nextStates.add(nextState);
                if (nextStates.size() <= this.maxSolutions()) continue;
                return nextStates;
            }
        }
        return nextStates;
    }

    @Value.Immutable
    static abstract class State
    implements Comparable<State> {
        State() {
        }

        @Value.Parameter(order=1)
        public abstract Optional<State> parent();

        @Value.Parameter(order=2)
        public abstract BpSeq bpSeq();

        @Value.Parameter(order=3)
        public abstract int level();

        @Value.Lazy
        public int score() {
            return this.bpSeq().paired().size();
        }

        @Override
        public final int compareTo(State t) {
            return new CompareToBuilder().append(this.level(), t.level()).append(this.score(), t.score()).build();
        }

        private boolean isFinal() {
            return this.score() == 0;
        }

        private int size() {
            return this.bpSeq().size();
        }
    }
}

