/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.immutables.value.Value;
import pl.poznan.put.pdb.ChainNumberICode;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.pdb.analysis.PdbChain;
import pl.poznan.put.pdb.analysis.PdbModel;
import pl.poznan.put.pdb.analysis.SingleTypedResidueCollection;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.formats.BpSeq;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.ImmutableCt;
import pl.poznan.put.structure.formats.ImmutableExtendedEntry;
import pl.poznan.put.structure.pseudoknots.Region;

@Value.Immutable
public abstract class Ct
implements Serializable {
    public static Ct fromString(String data) {
        List entries = Arrays.stream(data.split("\n")).map(String::trim).map(line -> line.indexOf(35) == -1 ? line : line.substring(0, line.indexOf(35))).filter(StringUtils::isNotBlank).skip(1L).map(ExtendedEntry::fromString).collect(Collectors.toList());
        return ImmutableCt.of(entries);
    }

    public static Ct fromBpSeq(BpSeq bpSeq) {
        List entries = bpSeq.entries().stream().map(ExtendedEntry::fromEntry).collect(Collectors.toList());
        return ImmutableCt.of(entries);
    }

    public static Ct fromBpSeqAndPdbModel(BpSeq bpSeq, PdbModel model) {
        List residues = model.chains().stream().filter(chain -> chain.moleculeType() == MoleculeType.RNA).map(PdbChain::residues).flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList<BpSeq.Entry> entries = new ArrayList<BpSeq.Entry>(bpSeq.entries());
        if (residues.size() != entries.size()) {
            throw new IllegalArgumentException(String.format("Failed to create CT from BPSEQ and PDB data, because there are %d BPSEQ entries and %d residues", entries.size(), residues.size()));
        }
        List extendedEntries = IntStream.range(0, entries.size()).mapToObj(i -> ExtendedEntry.fromEntryAndPdbResidue((BpSeq.Entry)entries.get(i), (ChainNumberICode)residues.get(i), model)).collect(Collectors.toList());
        return ImmutableCt.of(extendedEntries);
    }

    public static Ct fromDotBracket(DotBracket dotBracket) {
        List entries = dotBracket.strands().stream().map(DotBracket::symbols).flatMap(symbols -> IntStream.range(0, symbols.size()).mapToObj(i -> ExtendedEntry.fromDotBracketSymbol(dotBracket, symbols, i))).collect(Collectors.toList());
        return ImmutableCt.of(entries);
    }

    @Value.Parameter(order=1)
    @Value.NaturalOrder
    public abstract SortedSet<ExtendedEntry> entries();

    public final int strandCount() {
        return (int)this.entries().stream().filter(entry -> entry.after() == 0).count();
    }

    public final Ct withoutPair(ExtendedEntry entry) {
        if (!entry.isPaired()) {
            return ImmutableCt.copyOf(this);
        }
        TreeSet<ExtendedEntry> entrySet = new TreeSet<ExtendedEntry>(this.entries());
        entrySet.remove(entry);
        entrySet.add(ImmutableExtendedEntry.copyOf(entry).withPair(0));
        Optional<ExtendedEntry> paired = this.entries().stream().filter(e -> e.pair() == entry.index()).findFirst();
        if (paired.isPresent()) {
            entrySet.remove(paired.get());
            entrySet.add(ImmutableExtendedEntry.copyOf(paired.get()).withPair(0));
        }
        return ImmutableCt.of(entrySet);
    }

    public final Ct withoutIsolatedPairs() {
        Ct copy = ImmutableCt.copyOf(this);
        for (Region region : Region.createRegions(BpSeq.fromCt(this))) {
            Optional<ExtendedEntry> entry;
            if (region.length() != 1 || !(entry = this.entries().stream().filter(e -> e.index() == region.entries().get(0).index()).findFirst()).isPresent()) continue;
            copy = copy.withoutPair(entry.get());
        }
        return copy;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.entries().size());
        builder.append('\n');
        for (ExtendedEntry e : this.entries()) {
            builder.append(e);
            builder.append('\n');
        }
        return builder.toString();
    }

    @Value.Check
    protected Ct validate() {
        ArrayList<ExtendedEntry> list = new ArrayList<ExtendedEntry>(this.entries());
        ExtendedEntry lastEntry = (ExtendedEntry)list.get(list.size() - 1);
        if (lastEntry.after() != 0) {
            list.remove(list.size() - 1);
            list.add(ImmutableExtendedEntry.copyOf(lastEntry).withAfter(0));
            return ImmutableCt.of(list);
        }
        Validate.isTrue((((ExtendedEntry)list.get(0)).before() == 0 ? 1 : 0) != 0, (String)"Invalid `before` column (expected value is 0 for the first entry):%n  %s", (Object[])new Object[]{list.get(0)});
        for (int i = 1; i < list.size(); ++i) {
            ExtendedEntry previous = (ExtendedEntry)list.get(i - 1);
            ExtendedEntry current = (ExtendedEntry)list.get(i);
            Validate.isTrue((current.index() - previous.index() == 1 ? 1 : 0) != 0, (String)"Invalid `index` column (expected next value than its predecessor):%n  %s%n  %s", (Object[])new Object[]{previous, current});
            if (current.before() != 0) {
                Validate.isTrue((current.before() - previous.before() == 1 ? 1 : 0) != 0, (String)"Invalid `before` column (expected next value than its predecessor):%n  %s%n  %s", (Object[])new Object[]{previous, current});
            }
            if (previous.after() == 0) {
                Validate.isTrue((current.before() == 0 ? 1 : 0) != 0, (String)"Invalid `before` column (expected 0 for new strand):%n  %s%n  %s", (Object[])new Object[]{previous, current});
                Validate.isTrue((current.after() == 0 || current.after() == 2 ? 1 : 0) != 0, (String)"Invalid `after` column (expected 2 for new strand or 0 for a 1nt long strand):%n  %s%n  %s", (Object[])new Object[]{previous, current});
                continue;
            }
            Validate.isTrue((current.after() == 0 || current.after() - previous.after() == 1 ? 1 : 0) != 0, (String)"Invalid `after` column (expected next value than its predecessor):%n  %s%n  %s", (Object[])new Object[]{previous, current});
        }
        Map<Integer, Integer> map = this.entries().stream().collect(Collectors.toMap(ExtendedEntry::index, ExtendedEntry::pair));
        int lastIndex = lastEntry.index();
        for (ExtendedEntry entry : list) {
            if (entry.pair() != 0) {
                Validate.isTrue((boolean)map.containsKey(entry.index()), (String)"Missing mapping for:%n  %s", (Object[])new Object[]{entry});
                Validate.isTrue((boolean)map.containsKey(entry.pair()), (String)"Missing mapping for:%n  %s", (Object[])new Object[]{entry});
                Validate.isTrue((map.get(entry.index()).intValue() == entry.pair() ? 1 : 0) != 0, (String)"Incorrect mapping:%n  %s%n  mapping[entry.index]=%d", (Object[])new Object[]{entry, map.get(entry.index())});
                Validate.isTrue((map.get(entry.pair()).intValue() == entry.index() ? 1 : 0) != 0, (String)"Incorrect mapping:%n  %s%n  mapping[entry.pair]=%d", (Object[])new Object[]{entry, map.get(entry.pair())});
            }
            Validate.isTrue((entry.before() >= 0 ? 1 : 0) != 0, (String)"Invalid `before` column (expected positive value):%n  %s", (Object[])new Object[]{entry});
            Validate.isTrue((entry.before() < lastIndex ? 1 : 0) != 0, (String)"Invalid `before` column (expected value less than %d):%n  %s", (Object[])new Object[]{lastIndex, entry});
            Validate.isTrue((entry.after() == 0 || entry.after() >= 2 ? 1 : 0) != 0, (String)"Invalid `after` column (expected value at least 2):%n  %s", (Object[])new Object[]{entry});
            Validate.isTrue((entry.after() <= lastIndex ? 1 : 0) != 0, (String)"Invalid `after` column (expected value at most %d):%n  %s", (Object[])new Object[]{lastIndex, entry});
        }
        return this;
    }

    @Value.Immutable
    public static abstract class ExtendedEntry
    implements Comparable<ExtendedEntry> {
        public static ExtendedEntry fromString(String line) {
            String[] split = StringUtils.split((String)line);
            if (split.length != 6) {
                throw new IllegalArgumentException("Line does not conform to CT format: " + line);
            }
            try {
                int index = Integer.parseInt(split[0]);
                char seq = split[1].charAt(0);
                int before = Integer.parseInt(split[2]);
                int after = Integer.parseInt(split[3]);
                int pair = Integer.parseInt(split[4]);
                int original = Integer.parseInt(split[5]);
                return ImmutableExtendedEntry.of(index, seq, before, after, pair, original);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid CT format. Failed to parse column values: " + line, e);
            }
        }

        public static ExtendedEntry fromEntry(BpSeq.Entry entry) {
            return ImmutableExtendedEntry.of(entry.index(), entry.seq(), entry.index() - 1, entry.index() + 1, entry.pair(), entry.index());
        }

        public static ExtendedEntry fromEntryAndPdbResidue(BpSeq.Entry entry, ChainNumberICode residue, PdbModel model) {
            SingleTypedResidueCollection chain = model.findChainContainingResidue(residue);
            int before = chain.indexOf(residue);
            int after = (before + 2) % (chain.residues().size() + 1);
            return ImmutableExtendedEntry.of(entry.index(), entry.seq(), before, after, entry.pair(), residue.residueNumber()).withComment(entry.comment());
        }

        public static ExtendedEntry fromDotBracketSymbol(DotBracket dotBracket, List<DotBracketSymbol> symbols, int i) {
            Map<DotBracketSymbol, DotBracketSymbol> pairs = dotBracket.pairs();
            DotBracketSymbol symbol = symbols.get(i);
            return ImmutableExtendedEntry.of(symbol.index() + 1, symbol.sequence(), i, i == symbols.size() - 1 ? 0 : i + 2, pairs.containsKey(symbol) ? pairs.get(symbol).index() + 1 : 0, dotBracket.originalIndex(symbol));
        }

        @Value.Parameter(order=1)
        public abstract int index();

        @Value.Parameter(order=2)
        public abstract char seq();

        @Value.Parameter(order=3)
        public abstract int before();

        @Value.Parameter(order=4)
        public abstract int after();

        @Value.Parameter(order=5)
        public abstract int pair();

        @Value.Parameter(order=6)
        public abstract int original();

        @Value.Default
        public String comment() {
            return "";
        }

        public boolean isPaired() {
            return this.pair() != 0;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.index());
            builder.append(' ');
            builder.append(this.seq());
            builder.append(' ');
            builder.append(this.before());
            builder.append(' ');
            builder.append(this.after());
            builder.append(' ');
            builder.append(this.pair());
            builder.append(' ');
            builder.append(this.original());
            if (!StringUtils.isBlank((CharSequence)this.comment())) {
                builder.append(" # ");
                builder.append(this.comment());
            }
            return builder.toString();
        }

        @Override
        public int compareTo(ExtendedEntry t) {
            return Integer.compare(this.index(), t.index());
        }
    }
}

