/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.immutables.value.Value;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.structure.ClassifiedBasePair;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.formats.AbstractCombinedStrand;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.DotBracketFromPdb;
import pl.poznan.put.structure.formats.Strand;

@Value.Immutable
public abstract class CombinedStrandFromPdb
extends AbstractCombinedStrand
implements DotBracketFromPdb {
    @Override
    @Value.Parameter(order=1)
    protected abstract List<Strand> inputStrands();

    @Override
    @Value.Lazy
    public List<DotBracketSymbol> symbols() {
        return super.symbols();
    }

    @Override
    @Value.Lazy
    public List<Strand> strands() {
        return super.strands();
    }

    @Value.Parameter(order=2)
    protected abstract Map<DotBracketSymbol, PdbResidueIdentifier> inputSymbolToResidue();

    @Override
    public final int originalIndex(DotBracketSymbol symbol) {
        return ((PdbResidueIdentifier)this.mapping().get((Object)symbol)).residueNumber();
    }

    @Override
    @Value.Lazy
    @Value.Auxiliary
    public Map<DotBracketSymbol, DotBracketSymbol> pairs() {
        return super.pairs();
    }

    @Override
    public final PdbResidueIdentifier identifier(DotBracketSymbol symbol) {
        return (PdbResidueIdentifier)this.mapping().get((Object)symbol);
    }

    @Override
    public final DotBracketSymbol symbol(PdbResidueIdentifier residueIdentifier) {
        return (DotBracketSymbol)this.mapping().getKey((Object)residueIdentifier);
    }

    @Override
    public final boolean contains(PdbResidueIdentifier residueIdentifier) {
        return this.mapping().containsValue((Object)residueIdentifier);
    }

    @Override
    public final List<DotBracketFromPdb> combineStrands(List<ClassifiedBasePair> unused) {
        return Collections.singletonList(this);
    }

    @Override
    public final Set<PdbResidueIdentifier> identifierSet() {
        return this.mapping().values();
    }

    @Value.Lazy
    @Value.Auxiliary
    protected Map<DotBracketSymbol, PdbResidueIdentifier> symbolToResidue() {
        List inputSymbols = this.inputStrands().stream().map(DotBracket::symbols).flatMap(Collection::stream).collect(Collectors.toList());
        return IntStream.range(0, inputSymbols.size()).boxed().collect(Collectors.toMap(i -> this.symbols().get((int)i), i -> this.inputSymbolToResidue().get(inputSymbols.get((int)i))));
    }

    @Value.Lazy
    @Value.Auxiliary
    protected BidiMap<DotBracketSymbol, PdbResidueIdentifier> mapping() {
        return new DualHashBidiMap(this.symbols().stream().collect(Collectors.toMap(Function.identity(), this.symbolToResidue()::get)));
    }
}

