/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.immutables.value.Value;
import pl.poznan.put.pdb.PdbNamedResidueIdentifier;
import pl.poznan.put.pdb.analysis.ResidueTypeDetector;
import pl.poznan.put.structure.BasePair;
import pl.poznan.put.structure.ClassifiedBasePair;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.formats.Ct;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.ImmutableBpSeq;
import pl.poznan.put.structure.formats.ImmutableEntry;
import pl.poznan.put.structure.pseudoknots.Region;

@Value.Immutable
public abstract class BpSeq
implements Serializable {
    public static BpSeq fromString(String data) {
        Collection entries = Arrays.stream(data.split("\n")).map(String::trim).map(line -> line.indexOf(35) == -1 ? line : line.substring(0, line.indexOf(35))).filter(StringUtils::isNotBlank).map(Entry::fromString).collect(Collectors.toList());
        return ImmutableBpSeq.of(entries);
    }

    public static BpSeq fromCt(Ct ct) {
        List entries = ct.entries().stream().map(entry -> ImmutableEntry.of(entry.index(), entry.seq(), entry.pair())).collect(Collectors.toList());
        return ImmutableBpSeq.of(entries);
    }

    public static BpSeq fromDotBracket(DotBracket db) {
        Map<DotBracketSymbol, DotBracketSymbol> pairs = db.pairs();
        List entries = db.symbols().stream().map(symbol -> ImmutableEntry.of(symbol.index() + 1, symbol.sequence(), pairs.containsKey(symbol) ? ((DotBracketSymbol)pairs.get(symbol)).index() + 1 : 0)).collect(Collectors.toList());
        return ImmutableBpSeq.of(entries);
    }

    public static BpSeq fromBasePairs(List<PdbNamedResidueIdentifier> residues, Collection<? extends ClassifiedBasePair> basePairs) {
        List entries = Stream.concat(BpSeq.generateEntriesForPaired(residues, basePairs).stream(), BpSeq.generateEntriesForUnpaired(residues, basePairs).stream()).collect(Collectors.toList());
        return ImmutableBpSeq.of(entries);
    }

    private static Collection<Entry> generateEntriesForPaired(List<PdbNamedResidueIdentifier> residues, Collection<? extends ClassifiedBasePair> basePairs) {
        Map<BasePair, String> comments = basePairs.stream().filter(basePair -> !basePair.isCanonical()).flatMap(basePair -> Stream.of(basePair, basePair.invert())).distinct().collect(Collectors.toMap(ClassifiedBasePair::basePair, ClassifiedBasePair::generateComment));
        return basePairs.stream().flatMap(basePair -> Stream.of(basePair, basePair.invert())).map(ClassifiedBasePair::basePair).map(basePair -> ImmutableEntry.of(residues.indexOf(basePair.left()) + 1, basePair.left().oneLetterName(), residues.indexOf(basePair.right()) + 1).withComment(comments.getOrDefault(basePair, ""))).collect(Collectors.toList());
    }

    private static Collection<Entry> generateEntriesForUnpaired(List<PdbNamedResidueIdentifier> residues, Collection<? extends ClassifiedBasePair> basePairs) {
        Set paired = basePairs.stream().map(ClassifiedBasePair::basePair).flatMap(basePair -> Stream.of(basePair.left(), basePair.right())).collect(Collectors.toSet());
        return IntStream.range(0, residues.size()).filter(i -> !paired.contains(residues.get(i))).mapToObj(i -> ImmutableEntry.of(i + 1, ((PdbNamedResidueIdentifier)residues.get(i)).oneLetterName(), 0)).collect(Collectors.toList());
    }

    @Value.Parameter(order=1)
    @Value.NaturalOrder
    public abstract SortedSet<Entry> entries();

    public final String sequence() {
        return this.entries().stream().map(e -> String.valueOf(e.seq())).collect(Collectors.joining());
    }

    public final SortedSet<Entry> paired() {
        return this.entries().stream().filter(entry -> entry.index() < entry.pair()).collect(Collectors.toCollection(TreeSet::new));
    }

    public final int size() {
        return this.entries().size();
    }

    public final boolean hasAnyPair() {
        return this.entries().stream().anyMatch(Entry::isPaired);
    }

    public final BpSeq withoutIsolatedPairs() {
        List toRemove = Region.createRegions(this).stream().filter(region -> region.length() == 1).map(region -> region.entries().get(0)).collect(Collectors.toList());
        BpSeq result = ImmutableBpSeq.copyOf(this);
        for (Entry entry : toRemove) {
            result = result.withoutPair(entry);
        }
        return result;
    }

    public final BpSeq withoutPair(Entry entry) {
        if (!entry.isPaired()) {
            return ImmutableBpSeq.copyOf(this);
        }
        TreeSet<Entry> entriesCopy = new TreeSet<Entry>(this.entries());
        entriesCopy.remove(entry);
        entriesCopy.add(ImmutableEntry.copyOf(entry).withPair(0));
        Optional<Entry> paired = this.entries().stream().filter(e -> e.index() == entry.pair()).findFirst();
        if (paired.isPresent()) {
            entriesCopy.remove(paired.get());
            entriesCopy.add(ImmutableEntry.copyOf(paired.get()).withPair(0));
        }
        return ImmutableBpSeq.of(entriesCopy);
    }

    public final String toString() {
        return this.entries().stream().map(e -> e + System.lineSeparator()).collect(Collectors.joining());
    }

    @Value.Check
    protected void validate() {
        Map<Integer, Integer> map = this.entries().stream().collect(Collectors.toMap(Entry::index, Entry::pair));
        int previous = 0;
        for (Entry entry : this.entries()) {
            Validate.isTrue((entry.index() != entry.pair() ? 1 : 0) != 0, (String)"Invalid line in BPSEQ data, a residue cannot be paired with itself! Line: %s", (Object[])new Object[]{entry});
            Validate.isTrue((entry.index() - previous == 1 ? 1 : 0) != 0, (String)"Inconsistent numbering in BPSEQ format: previous=%d, current=%d", (Object[])new Object[]{previous, entry.index()});
            previous = entry.index();
            int pair = map.get(entry.index());
            if (pair == 0) continue;
            Validate.isTrue((boolean)map.containsKey(pair), (String)"Inconsistency in BPSEQ format: (%d -> %d)", (Object[])new Object[]{entry.index(), pair});
            Validate.isTrue((map.get(pair).intValue() == entry.index() ? 1 : 0) != 0, (String)"Inconsistency in BPSEQ format: (%d -> %d) and (%d -> %d)", (Object[])new Object[]{entry.index(), pair, pair, map.get(pair)});
        }
    }

    @Value.Immutable
    public static abstract class Entry
    implements Comparable<Entry>,
    Serializable {
        public static Entry fromString(String line) {
            String[] split = StringUtils.split((String)line);
            if (split.length != 3) {
                throw new IllegalArgumentException("Line does not conform to BPSEQ format: " + line);
            }
            try {
                int index = Integer.parseInt(split[0]);
                char seq = ResidueTypeDetector.detectResidueType(split[1], Collections.emptySet()).oneLetterName();
                int pair = Integer.parseInt(split[2]);
                return ImmutableEntry.of(index, seq, pair);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Line does not conform to BPSEQ format: %s", line), e);
            }
        }

        @Value.Parameter(order=1)
        public abstract int index();

        @Value.Parameter(order=2)
        public abstract char seq();

        @Value.Parameter(order=3)
        public abstract int pair();

        @Value.Default
        public String comment() {
            return "";
        }

        public boolean isPaired() {
            return this.pair() != 0;
        }

        public final boolean contains(int index) {
            return index > this.index() && index < this.pair();
        }

        public final int length() {
            return this.pair() == 0 ? 0 : this.pair() - this.index();
        }

        @Override
        public final int compareTo(Entry t) {
            return Integer.compare(this.index(), t.index());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(10 + this.comment().length());
            builder.append(this.index());
            builder.append(' ');
            builder.append(this.seq());
            builder.append(' ');
            builder.append(this.pair());
            return builder.toString();
        }
    }
}

