/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.ImmutableDotBracketSymbol;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.Strand;

abstract class AbstractDotBracket
implements DotBracket {
    AbstractDotBracket() {
    }

    @Override
    public List<DotBracketSymbol> symbols() {
        return IntStream.range(0, this.sequence().length()).mapToObj(i -> ImmutableDotBracketSymbol.of(this.sequence().charAt(i), this.structure().charAt(i), i)).collect(Collectors.toList());
    }

    protected final List<List<Strand>> candidatesToCombine() {
        ArrayList<List<Strand>> result = new ArrayList<List<Strand>>();
        ArrayList<Strand> toCombine = new ArrayList<Strand>();
        int level = 0;
        for (Strand strand : this.strands()) {
            toCombine.add(strand);
            for (DotBracketSymbol symbol : strand.symbols()) {
                level += symbol.isOpening() ? 1 : 0;
                level -= symbol.isClosing() ? 1 : 0;
            }
            if (level != 0) continue;
            result.add(new ArrayList(toCombine));
            toCombine.clear();
        }
        return result;
    }
}

