/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.ImmutableDotBracketSymbol;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.ImmutableDefaultStrand;
import pl.poznan.put.structure.formats.Strand;

public abstract class AbstractCombinedStrand
implements DotBracket {
    protected abstract List<Strand> inputStrands();

    @Override
    public List<DotBracketSymbol> symbols() {
        return this.strands().stream().map(DotBracket::symbols).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<Strand> strands() {
        ArrayList<Strand> strands = new ArrayList<Strand>();
        int i = 0;
        for (Strand strand : this.inputStrands()) {
            ArrayList<DotBracketSymbol> renumbered = new ArrayList<DotBracketSymbol>(strand.symbols().size());
            for (DotBracketSymbol symbol : strand.symbols()) {
                renumbered.add(ImmutableDotBracketSymbol.copyOf(symbol).withIndex(i));
                ++i;
            }
            strands.add(ImmutableDefaultStrand.of(strand.name(), renumbered));
        }
        return strands;
    }
}

