/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.notation.BPh;
import pl.poznan.put.notation.BR;
import pl.poznan.put.notation.LeontisWesthof;
import pl.poznan.put.notation.Saenger;
import pl.poznan.put.rna.InteractionType;
import pl.poznan.put.structure.BasePair;
import pl.poznan.put.structure.ClassifiedBasePair;
import pl.poznan.put.structure.QuantifiedBasePair;

@ParametersAreNonnullByDefault
@Generated(from="QuantifiedBasePair", generator="Immutables")
@Immutable
public final class ImmutableQuantifiedBasePair
extends QuantifiedBasePair {
    private final BasePair basePair;
    private final InteractionType interactionType;
    private final Saenger saenger;
    private final LeontisWesthof leontisWesthof;
    private final BPh bph;
    private final BR br;
    private final boolean isRepresented;
    private final double shear;
    private final double stretch;
    private final double stagger;
    private final double buckle;
    private final double propeller;
    private final double opening;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableQuantifiedBasePair(BasePair basePair, double shear, double stretch, double stagger, double buckle, double propeller, double opening) {
        this.basePair = Objects.requireNonNull(basePair, "basePair");
        this.shear = shear;
        this.stretch = stretch;
        this.stagger = stagger;
        this.buckle = buckle;
        this.propeller = propeller;
        this.opening = opening;
        this.interactionType = this.initShim.interactionType();
        this.saenger = this.initShim.saenger();
        this.leontisWesthof = this.initShim.leontisWesthof();
        this.bph = this.initShim.bph();
        this.br = this.initShim.br();
        this.isRepresented = this.initShim.isRepresented();
        this.initShim = null;
    }

    private ImmutableQuantifiedBasePair(Builder builder) {
        this.basePair = builder.basePair;
        this.shear = builder.shear;
        this.stretch = builder.stretch;
        this.stagger = builder.stagger;
        this.buckle = builder.buckle;
        this.propeller = builder.propeller;
        this.opening = builder.opening;
        if (builder.interactionType != null) {
            this.initShim.interactionType(builder.interactionType);
        }
        if (builder.saenger != null) {
            this.initShim.saenger(builder.saenger);
        }
        if (builder.leontisWesthof != null) {
            this.initShim.leontisWesthof(builder.leontisWesthof);
        }
        if (builder.bph != null) {
            this.initShim.bph(builder.bph);
        }
        if (builder.br != null) {
            this.initShim.br(builder.br);
        }
        if (builder.isRepresentedIsSet()) {
            this.initShim.isRepresented(builder.isRepresented);
        }
        this.interactionType = this.initShim.interactionType();
        this.saenger = this.initShim.saenger();
        this.leontisWesthof = this.initShim.leontisWesthof();
        this.bph = this.initShim.bph();
        this.br = this.initShim.br();
        this.isRepresented = this.initShim.isRepresented();
        this.initShim = null;
    }

    private ImmutableQuantifiedBasePair(BasePair basePair, InteractionType interactionType, Saenger saenger, LeontisWesthof leontisWesthof, BPh bph, BR br, boolean isRepresented, double shear, double stretch, double stagger, double buckle, double propeller, double opening) {
        this.basePair = basePair;
        this.interactionType = interactionType;
        this.saenger = saenger;
        this.leontisWesthof = leontisWesthof;
        this.bph = bph;
        this.br = br;
        this.isRepresented = isRepresented;
        this.shear = shear;
        this.stretch = stretch;
        this.stagger = stagger;
        this.buckle = buckle;
        this.propeller = propeller;
        this.opening = opening;
        this.initShim = null;
    }

    @Override
    public BasePair basePair() {
        return this.basePair;
    }

    @Override
    public InteractionType interactionType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.interactionType() : this.interactionType;
    }

    @Override
    public Saenger saenger() {
        InitShim shim = this.initShim;
        return shim != null ? shim.saenger() : this.saenger;
    }

    @Override
    public LeontisWesthof leontisWesthof() {
        InitShim shim = this.initShim;
        return shim != null ? shim.leontisWesthof() : this.leontisWesthof;
    }

    @Override
    public BPh bph() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bph() : this.bph;
    }

    @Override
    public BR br() {
        InitShim shim = this.initShim;
        return shim != null ? shim.br() : this.br;
    }

    @Override
    public boolean isRepresented() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isRepresented() : this.isRepresented;
    }

    @Override
    public double shear() {
        return this.shear;
    }

    @Override
    public double stretch() {
        return this.stretch;
    }

    @Override
    public double stagger() {
        return this.stagger;
    }

    @Override
    public double buckle() {
        return this.buckle;
    }

    @Override
    public double propeller() {
        return this.propeller;
    }

    @Override
    public double opening() {
        return this.opening;
    }

    public final ImmutableQuantifiedBasePair withBasePair(BasePair value) {
        if (this.basePair == value) {
            return this;
        }
        BasePair newValue = Objects.requireNonNull(value, "basePair");
        return new ImmutableQuantifiedBasePair(newValue, this.interactionType, this.saenger, this.leontisWesthof, this.bph, this.br, this.isRepresented, this.shear, this.stretch, this.stagger, this.buckle, this.propeller, this.opening);
    }

    public final ImmutableQuantifiedBasePair withInteractionType(InteractionType value) {
        if (this.interactionType == value) {
            return this;
        }
        InteractionType newValue = Objects.requireNonNull(value, "interactionType");
        return new ImmutableQuantifiedBasePair(this.basePair, newValue, this.saenger, this.leontisWesthof, this.bph, this.br, this.isRepresented, this.shear, this.stretch, this.stagger, this.buckle, this.propeller, this.opening);
    }

    public final ImmutableQuantifiedBasePair withSaenger(Saenger value) {
        if (this.saenger == value) {
            return this;
        }
        Saenger newValue = Objects.requireNonNull(value, "saenger");
        if (this.saenger.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableQuantifiedBasePair(this.basePair, this.interactionType, newValue, this.leontisWesthof, this.bph, this.br, this.isRepresented, this.shear, this.stretch, this.stagger, this.buckle, this.propeller, this.opening);
    }

    public final ImmutableQuantifiedBasePair withLeontisWesthof(LeontisWesthof value) {
        if (this.leontisWesthof == value) {
            return this;
        }
        LeontisWesthof newValue = Objects.requireNonNull(value, "leontisWesthof");
        if (this.leontisWesthof.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableQuantifiedBasePair(this.basePair, this.interactionType, this.saenger, newValue, this.bph, this.br, this.isRepresented, this.shear, this.stretch, this.stagger, this.buckle, this.propeller, this.opening);
    }

    public final ImmutableQuantifiedBasePair withBph(BPh value) {
        if (this.bph == value) {
            return this;
        }
        BPh newValue = Objects.requireNonNull(value, "bph");
        if (this.bph.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableQuantifiedBasePair(this.basePair, this.interactionType, this.saenger, this.leontisWesthof, newValue, this.br, this.isRepresented, this.shear, this.stretch, this.stagger, this.buckle, this.propeller, this.opening);
    }

    public final ImmutableQuantifiedBasePair withBr(BR value) {
        if (this.br == value) {
            return this;
        }
        BR newValue = Objects.requireNonNull(value, "br");
        if (this.br.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableQuantifiedBasePair(this.basePair, this.interactionType, this.saenger, this.leontisWesthof, this.bph, newValue, this.isRepresented, this.shear, this.stretch, this.stagger, this.buckle, this.propeller, this.opening);
    }

    public final ImmutableQuantifiedBasePair withIsRepresented(boolean value) {
        if (this.isRepresented == value) {
            return this;
        }
        return new ImmutableQuantifiedBasePair(this.basePair, this.interactionType, this.saenger, this.leontisWesthof, this.bph, this.br, value, this.shear, this.stretch, this.stagger, this.buckle, this.propeller, this.opening);
    }

    public final ImmutableQuantifiedBasePair withShear(double value) {
        if (Double.doubleToLongBits(this.shear) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableQuantifiedBasePair(this.basePair, this.interactionType, this.saenger, this.leontisWesthof, this.bph, this.br, this.isRepresented, value, this.stretch, this.stagger, this.buckle, this.propeller, this.opening);
    }

    public final ImmutableQuantifiedBasePair withStretch(double value) {
        if (Double.doubleToLongBits(this.stretch) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableQuantifiedBasePair(this.basePair, this.interactionType, this.saenger, this.leontisWesthof, this.bph, this.br, this.isRepresented, this.shear, value, this.stagger, this.buckle, this.propeller, this.opening);
    }

    public final ImmutableQuantifiedBasePair withStagger(double value) {
        if (Double.doubleToLongBits(this.stagger) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableQuantifiedBasePair(this.basePair, this.interactionType, this.saenger, this.leontisWesthof, this.bph, this.br, this.isRepresented, this.shear, this.stretch, value, this.buckle, this.propeller, this.opening);
    }

    public final ImmutableQuantifiedBasePair withBuckle(double value) {
        if (Double.doubleToLongBits(this.buckle) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableQuantifiedBasePair(this.basePair, this.interactionType, this.saenger, this.leontisWesthof, this.bph, this.br, this.isRepresented, this.shear, this.stretch, this.stagger, value, this.propeller, this.opening);
    }

    public final ImmutableQuantifiedBasePair withPropeller(double value) {
        if (Double.doubleToLongBits(this.propeller) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableQuantifiedBasePair(this.basePair, this.interactionType, this.saenger, this.leontisWesthof, this.bph, this.br, this.isRepresented, this.shear, this.stretch, this.stagger, this.buckle, value, this.opening);
    }

    public final ImmutableQuantifiedBasePair withOpening(double value) {
        if (Double.doubleToLongBits(this.opening) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableQuantifiedBasePair(this.basePair, this.interactionType, this.saenger, this.leontisWesthof, this.bph, this.br, this.isRepresented, this.shear, this.stretch, this.stagger, this.buckle, this.propeller, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQuantifiedBasePair && this.equalTo((ImmutableQuantifiedBasePair)another);
    }

    private boolean equalTo(ImmutableQuantifiedBasePair another) {
        return this.basePair.equals(another.basePair) && this.interactionType.equals(another.interactionType) && this.saenger.equals((Object)another.saenger) && this.leontisWesthof.equals((Object)another.leontisWesthof) && this.bph.equals((Object)another.bph) && this.br.equals((Object)another.br);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.basePair.hashCode();
        h += (h << 5) + this.interactionType.hashCode();
        h += (h << 5) + this.saenger.hashCode();
        h += (h << 5) + this.leontisWesthof.hashCode();
        h += (h << 5) + this.bph.hashCode();
        h += (h << 5) + this.br.hashCode();
        return h;
    }

    public String toString() {
        return "QuantifiedBasePair{basePair=" + this.basePair + ", interactionType=" + this.interactionType + ", saenger=" + (Object)((Object)this.saenger) + ", leontisWesthof=" + (Object)((Object)this.leontisWesthof) + ", bph=" + (Object)((Object)this.bph) + ", br=" + (Object)((Object)this.br) + "}";
    }

    public static ImmutableQuantifiedBasePair of(BasePair basePair, double shear, double stretch, double stagger, double buckle, double propeller, double opening) {
        return new ImmutableQuantifiedBasePair(basePair, shear, stretch, stagger, buckle, propeller, opening);
    }

    public static ImmutableQuantifiedBasePair copyOf(QuantifiedBasePair instance) {
        if (instance instanceof ImmutableQuantifiedBasePair) {
            return (ImmutableQuantifiedBasePair)instance;
        }
        return ImmutableQuantifiedBasePair.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QuantifiedBasePair", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BASE_PAIR = 1L;
        private static final long INIT_BIT_SHEAR = 2L;
        private static final long INIT_BIT_STRETCH = 4L;
        private static final long INIT_BIT_STAGGER = 8L;
        private static final long INIT_BIT_BUCKLE = 16L;
        private static final long INIT_BIT_PROPELLER = 32L;
        private static final long INIT_BIT_OPENING = 64L;
        private static final long OPT_BIT_IS_REPRESENTED = 1L;
        private long initBits = 127L;
        private long optBits;
        @Nullable
        private BasePair basePair;
        @Nullable
        private InteractionType interactionType;
        @Nullable
        private Saenger saenger;
        @Nullable
        private LeontisWesthof leontisWesthof;
        @Nullable
        private BPh bph;
        @Nullable
        private BR br;
        private boolean isRepresented;
        private double shear;
        private double stretch;
        private double stagger;
        private double buckle;
        private double propeller;
        private double opening;

        private Builder() {
        }

        public final Builder from(ClassifiedBasePair instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(QuantifiedBasePair instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ClassifiedBasePair instance;
            long bits = 0L;
            if (object instanceof ClassifiedBasePair) {
                instance = (ClassifiedBasePair)object;
                if ((bits & 8L) == 0L) {
                    this.br(instance.br());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.interactionType(instance.interactionType());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.saenger(instance.saenger());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.basePair(instance.basePair());
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.leontisWesthof(instance.leontisWesthof());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.bph(instance.bph());
                    bits |= 0x40L;
                }
                if ((bits & 4L) == 0L) {
                    this.isRepresented(instance.isRepresented());
                    bits |= 4L;
                }
            }
            if (object instanceof QuantifiedBasePair) {
                instance = (QuantifiedBasePair)object;
                this.shear(((QuantifiedBasePair)instance).shear());
                this.propeller(((QuantifiedBasePair)instance).propeller());
                if ((bits & 1L) == 0L) {
                    this.saenger(((QuantifiedBasePair)instance).saenger());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.basePair(((QuantifiedBasePair)instance).basePair());
                    bits |= 2L;
                }
                this.stagger(((QuantifiedBasePair)instance).stagger());
                this.opening(((QuantifiedBasePair)instance).opening());
                this.buckle(((QuantifiedBasePair)instance).buckle());
                if ((bits & 4L) == 0L) {
                    this.isRepresented(((QuantifiedBasePair)instance).isRepresented());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.br(((QuantifiedBasePair)instance).br());
                    bits |= 8L;
                }
                this.stretch(((QuantifiedBasePair)instance).stretch());
                if ((bits & 0x10L) == 0L) {
                    this.interactionType(((QuantifiedBasePair)instance).interactionType());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.leontisWesthof(((QuantifiedBasePair)instance).leontisWesthof());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.bph(((QuantifiedBasePair)instance).bph());
                    bits |= 0x40L;
                }
            }
        }

        public final Builder basePair(BasePair basePair) {
            this.basePair = Objects.requireNonNull(basePair, "basePair");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder interactionType(InteractionType interactionType) {
            this.interactionType = Objects.requireNonNull(interactionType, "interactionType");
            return this;
        }

        public final Builder saenger(Saenger saenger) {
            this.saenger = Objects.requireNonNull(saenger, "saenger");
            return this;
        }

        public final Builder leontisWesthof(LeontisWesthof leontisWesthof) {
            this.leontisWesthof = Objects.requireNonNull(leontisWesthof, "leontisWesthof");
            return this;
        }

        public final Builder bph(BPh bph) {
            this.bph = Objects.requireNonNull(bph, "bph");
            return this;
        }

        public final Builder br(BR br) {
            this.br = Objects.requireNonNull(br, "br");
            return this;
        }

        public final Builder isRepresented(boolean isRepresented) {
            this.isRepresented = isRepresented;
            this.optBits |= 1L;
            return this;
        }

        public final Builder shear(double shear) {
            this.shear = shear;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder stretch(double stretch) {
            this.stretch = stretch;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder stagger(double stagger) {
            this.stagger = stagger;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder buckle(double buckle) {
            this.buckle = buckle;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder propeller(double propeller) {
            this.propeller = propeller;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder opening(double opening) {
            this.opening = opening;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableQuantifiedBasePair build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQuantifiedBasePair(this);
        }

        private boolean isRepresentedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("basePair");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("shear");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("stretch");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("stagger");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("buckle");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("propeller");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("opening");
            }
            return "Cannot build QuantifiedBasePair, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="QuantifiedBasePair", generator="Immutables")
    private final class InitShim {
        private byte interactionTypeBuildStage = 0;
        private InteractionType interactionType;
        private byte saengerBuildStage = 0;
        private Saenger saenger;
        private byte leontisWesthofBuildStage = 0;
        private LeontisWesthof leontisWesthof;
        private byte bphBuildStage = 0;
        private BPh bph;
        private byte brBuildStage = 0;
        private BR br;
        private byte isRepresentedBuildStage = 0;
        private boolean isRepresented;

        private InitShim() {
        }

        InteractionType interactionType() {
            if (this.interactionTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.interactionTypeBuildStage == 0) {
                this.interactionTypeBuildStage = (byte)-1;
                this.interactionType = Objects.requireNonNull(ImmutableQuantifiedBasePair.super.interactionType(), "interactionType");
                this.interactionTypeBuildStage = 1;
            }
            return this.interactionType;
        }

        void interactionType(InteractionType interactionType) {
            this.interactionType = interactionType;
            this.interactionTypeBuildStage = 1;
        }

        Saenger saenger() {
            if (this.saengerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.saengerBuildStage == 0) {
                this.saengerBuildStage = (byte)-1;
                this.saenger = Objects.requireNonNull(ImmutableQuantifiedBasePair.super.saenger(), "saenger");
                this.saengerBuildStage = 1;
            }
            return this.saenger;
        }

        void saenger(Saenger saenger) {
            this.saenger = saenger;
            this.saengerBuildStage = 1;
        }

        LeontisWesthof leontisWesthof() {
            if (this.leontisWesthofBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.leontisWesthofBuildStage == 0) {
                this.leontisWesthofBuildStage = (byte)-1;
                this.leontisWesthof = Objects.requireNonNull(ImmutableQuantifiedBasePair.super.leontisWesthof(), "leontisWesthof");
                this.leontisWesthofBuildStage = 1;
            }
            return this.leontisWesthof;
        }

        void leontisWesthof(LeontisWesthof leontisWesthof) {
            this.leontisWesthof = leontisWesthof;
            this.leontisWesthofBuildStage = 1;
        }

        BPh bph() {
            if (this.bphBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bphBuildStage == 0) {
                this.bphBuildStage = (byte)-1;
                this.bph = Objects.requireNonNull(ImmutableQuantifiedBasePair.super.bph(), "bph");
                this.bphBuildStage = 1;
            }
            return this.bph;
        }

        void bph(BPh bph) {
            this.bph = bph;
            this.bphBuildStage = 1;
        }

        BR br() {
            if (this.brBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.brBuildStage == 0) {
                this.brBuildStage = (byte)-1;
                this.br = Objects.requireNonNull(ImmutableQuantifiedBasePair.super.br(), "br");
                this.brBuildStage = 1;
            }
            return this.br;
        }

        void br(BR br) {
            this.br = br;
            this.brBuildStage = 1;
        }

        boolean isRepresented() {
            if (this.isRepresentedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isRepresentedBuildStage == 0) {
                this.isRepresentedBuildStage = (byte)-1;
                this.isRepresented = ImmutableQuantifiedBasePair.super.isRepresented();
                this.isRepresentedBuildStage = 1;
            }
            return this.isRepresented;
        }

        void isRepresented(boolean isRepresented) {
            this.isRepresented = isRepresented;
            this.isRepresentedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.interactionTypeBuildStage == -1) {
                attributes.add("interactionType");
            }
            if (this.saengerBuildStage == -1) {
                attributes.add("saenger");
            }
            if (this.leontisWesthofBuildStage == -1) {
                attributes.add("leontisWesthof");
            }
            if (this.bphBuildStage == -1) {
                attributes.add("bph");
            }
            if (this.brBuildStage == -1) {
                attributes.add("br");
            }
            if (this.isRepresentedBuildStage == -1) {
                attributes.add("isRepresented");
            }
            return "Cannot build QuantifiedBasePair, attribute initializers form cycle " + attributes;
        }
    }
}

