/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public abstract class DotBracketSymbol
implements Comparable<DotBracketSymbol>,
Serializable {
    private static final List<Character> OPENING = "([{<ABCDEFGHIJKLMNOPQRSTUVWXYZ".chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toList());
    private static final List<Character> CLOSING = ")]}>abcdefghijklmnopqrstuvwxyz".chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toList());

    public static boolean isPairing(char c) {
        return DotBracketSymbol.isOpening(c) || DotBracketSymbol.isClosing(c);
    }

    public static boolean isOpening(char c) {
        return OPENING.contains(Character.valueOf(c));
    }

    public static boolean isClosing(char c) {
        return CLOSING.contains(Character.valueOf(c));
    }

    public static char matchingBracket(char c) {
        if (DotBracketSymbol.isOpening(c)) {
            return CLOSING.get(DotBracketSymbol.order(c)).charValue();
        }
        if (DotBracketSymbol.isClosing(c)) {
            return OPENING.get(DotBracketSymbol.order(c)).charValue();
        }
        return '.';
    }

    private static int order(char c) {
        int result = OPENING.indexOf(Character.valueOf(c));
        if (result == -1) {
            result = CLOSING.indexOf(Character.valueOf(c));
        }
        return result == -1 ? 0 : result;
    }

    @Value.Parameter(order=1)
    public abstract char sequence();

    @Value.Parameter(order=2)
    public abstract char structure();

    @Value.Parameter(order=3)
    public abstract int index();

    public final boolean isMissing() {
        return this.structure() == '-';
    }

    public final boolean isPairing() {
        return this.isOpening() || this.isClosing();
    }

    public final boolean isOpening() {
        return DotBracketSymbol.isOpening(this.structure());
    }

    public final boolean isClosing() {
        return DotBracketSymbol.isClosing(this.structure());
    }

    public final int order() {
        return DotBracketSymbol.order(this.structure());
    }

    public final String toString() {
        return this.index() + " " + this.sequence() + ' ' + this.structure();
    }

    @Override
    public final int compareTo(DotBracketSymbol t) {
        return Integer.compare(this.index(), t.index());
    }
}

