/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.builder.CompareToBuilder;
import pl.poznan.put.notation.BPh;
import pl.poznan.put.notation.BR;
import pl.poznan.put.notation.LeontisWesthof;
import pl.poznan.put.notation.Saenger;
import pl.poznan.put.rna.InteractionType;
import pl.poznan.put.structure.BasePair;

public interface ClassifiedBasePair
extends Serializable,
Comparable<ClassifiedBasePair> {
    public BasePair basePair();

    default public InteractionType interactionType() {
        return InteractionType.BASE_BASE;
    }

    default public Saenger saenger() {
        return Saenger.assumeCanonical(this.basePair());
    }

    default public LeontisWesthof leontisWesthof() {
        return LeontisWesthof.CWW;
    }

    default public BPh bph() {
        return BPh.UNKNOWN;
    }

    default public BR br() {
        return BR.UNKNOWN;
    }

    default public boolean isRepresented() {
        return false;
    }

    public ClassifiedBasePair invert();

    default public String generateComment() {
        if (this.saenger() != Saenger.UNKNOWN && this.leontisWesthof() != LeontisWesthof.UNKNOWN) {
            return "S:" + (Object)((Object)this.saenger()) + ", LW:" + (Object)((Object)this.leontisWesthof());
        }
        if (this.saenger() != Saenger.UNKNOWN) {
            return "S:" + (Object)((Object)this.saenger());
        }
        if (this.leontisWesthof() != LeontisWesthof.UNKNOWN) {
            return "LW:" + (Object)((Object)this.leontisWesthof());
        }
        return "unknown classification";
    }

    default public boolean isBaseRibose() {
        return Objects.equals(this.interactionType(), InteractionType.BASE_RIBOSE) || Objects.equals(this.interactionType().invert(), InteractionType.BASE_RIBOSE);
    }

    default public boolean isStacking() {
        return Objects.equals(this.interactionType(), InteractionType.STACKING);
    }

    default public boolean isBasePhosphate() {
        return Objects.equals(this.interactionType(), InteractionType.BASE_PHOSPHATE) || Objects.equals(this.interactionType().invert(), InteractionType.BASE_PHOSPHATE);
    }

    default public boolean isPairing() {
        return this.interactionType().isPairing();
    }

    default public boolean isNonCanonical() {
        return !Saenger.isCanonical(this.saenger()) && (Objects.equals(this.interactionType(), InteractionType.BASE_BASE) || Objects.equals(this.interactionType(), InteractionType.BASE_BASE_1H));
    }

    default public boolean isCanonical() {
        return Saenger.isCanonical(this.saenger()) && Objects.equals(this.interactionType(), InteractionType.BASE_BASE);
    }

    @Override
    default public int compareTo(ClassifiedBasePair t) {
        return new CompareToBuilder().append((Object)this.basePair(), (Object)t.basePair()).append((Object)this.interactionType(), (Object)t.interactionType()).append((Object)this.leontisWesthof(), (Object)t.leontisWesthof()).append((Object)this.saenger(), (Object)t.saenger()).append((Object)this.bph(), (Object)t.bph()).append((Object)this.br(), (Object)t.br()).build();
    }
}

