/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import pl.poznan.put.pdb.PdbNamedResidueIdentifier;
import pl.poznan.put.pdb.analysis.ImmutableDefaultResidueCollection;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.pdb.analysis.ResidueCollection;
import pl.poznan.put.structure.BasePair;
import pl.poznan.put.structure.ClassifiedBasePair;
import pl.poznan.put.structure.ImmutableAnalyzedBasePair;
import pl.poznan.put.structure.ImmutableBasePair;
import pl.poznan.put.structure.formats.BpSeq;

public final class CanonicalStructureExtractor {
    private CanonicalStructureExtractor() {
    }

    public static BpSeq bpSeq(ResidueCollection residueCollection) {
        List<PdbResidue> residues = residueCollection.residues().stream().filter(residue -> residue.residueInformationProvider().moleculeType() == MoleculeType.RNA).collect(Collectors.toList());
        ImmutableDefaultResidueCollection collection = ImmutableDefaultResidueCollection.of(residues);
        Collection<ClassifiedBasePair> basePairs = CanonicalStructureExtractor.basePairs(collection);
        return BpSeq.fromBasePairs(collection.namedResidueIdentifiers(), basePairs);
    }

    public static Collection<ClassifiedBasePair> basePairs(ResidueCollection residueCollection) {
        List<PdbResidue> residues = residueCollection.residues();
        ArrayList<ClassifiedBasePair> basePairs = new ArrayList<ClassifiedBasePair>();
        HashSet<PdbNamedResidueIdentifier> paired = new HashSet<PdbNamedResidueIdentifier>();
        for (int i = 0; i < residues.size(); ++i) {
            PdbResidue left = residues.get(i);
            for (int j = i + 1; j < residues.size(); ++j) {
                PdbResidue right = residues.get(j);
                if (!BasePair.isCanonicalPair(left, right)) continue;
                PdbNamedResidueIdentifier leftId = left.namedResidueIdentifier();
                PdbNamedResidueIdentifier rightId = right.namedResidueIdentifier();
                if (paired.contains(leftId) || paired.contains(rightId)) continue;
                basePairs.add(ImmutableAnalyzedBasePair.of(ImmutableBasePair.of(leftId, rightId)));
                paired.add(leftId);
                paired.add(rightId);
            }
        }
        return basePairs;
    }
}

