/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure;

import java.io.Serializable;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.immutables.value.Value;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.PdbNamedResidueIdentifier;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.structure.ImmutableBasePair;

@Value.Immutable
public abstract class BasePair
implements Serializable,
Comparable<BasePair> {
    private static final double GU_DISTANCE_O6_N3 = 3.22;
    private static final double GU_DISTANCE_N1_O2 = 3.18;
    private static final double AU_DISTANCE_N6_O4 = 3.51;
    private static final double AU_DISTANCE_N1_N3 = 3.1999999999999997;
    private static final double CG_DISTANCE_N4_O6 = 3.4699999999999998;
    private static final double CG_DISTANCE_O2_N2 = 3.2199999999999998;
    private static final double CG_DISTANCE_N3_N1 = 3.22;

    public static boolean isCanonicalPair(PdbResidue left, PdbResidue right) {
        char rightName;
        char leftName = Character.toUpperCase(left.oneLetterName());
        if (leftName > (rightName = Character.toUpperCase(right.oneLetterName()))) {
            return BasePair.isCanonicalPair(right, left);
        }
        if (leftName == 'C' && rightName == 'G') {
            return BasePair.isCanonicalCG(left, right);
        }
        if (leftName == 'A' && (rightName == 'U' || rightName == 'T')) {
            return BasePair.isCanonicalAU(left, right);
        }
        return leftName == 'G' && rightName == 'U' && BasePair.isCanonicalGU(left, right);
    }

    private static boolean isCanonicalGU(PdbResidue guanine, PdbResidue uracil) {
        if (!guanine.hasAtom(AtomName.N1) || !guanine.hasAtom(AtomName.O6)) {
            return false;
        }
        if (!uracil.hasAtom(AtomName.O2) || !uracil.hasAtom(AtomName.N3)) {
            return false;
        }
        PdbAtomLine n1 = guanine.findAtom(AtomName.N1);
        PdbAtomLine o6 = guanine.findAtom(AtomName.O6);
        PdbAtomLine o2 = uracil.findAtom(AtomName.O2);
        PdbAtomLine n3 = uracil.findAtom(AtomName.N3);
        double n1o2 = n1.distanceTo(o2);
        double o6n3 = o6.distanceTo(n3);
        return n1o2 <= 3.18 && o6n3 <= 3.22 && BasePair.isFacingYR(uracil, guanine);
    }

    private static boolean isCanonicalAU(PdbResidue adenine, PdbResidue uracil) {
        if (!adenine.hasAtom(AtomName.N1) || !adenine.hasAtom(AtomName.N6)) {
            return false;
        }
        if (!uracil.hasAtom(AtomName.N3) || !uracil.hasAtom(AtomName.O4)) {
            return false;
        }
        PdbAtomLine n1 = adenine.findAtom(AtomName.N1);
        PdbAtomLine n6 = adenine.findAtom(AtomName.N6);
        PdbAtomLine n3 = uracil.findAtom(AtomName.N3);
        PdbAtomLine o4 = uracil.findAtom(AtomName.O4);
        double n1n3 = n1.distanceTo(n3);
        double n6o4 = n6.distanceTo(o4);
        return n1n3 <= 3.1999999999999997 && n6o4 <= 3.51 && BasePair.isFacingYR(uracil, adenine);
    }

    private static boolean isCanonicalCG(PdbResidue cytosine, PdbResidue guanine) {
        if (Stream.of(AtomName.N3, AtomName.O2, AtomName.N4).anyMatch(atomName -> !cytosine.hasAtom((AtomName)((Object)atomName)))) {
            return false;
        }
        if (Stream.of(AtomName.N1, AtomName.N2, AtomName.O6).anyMatch(atomName -> !guanine.hasAtom((AtomName)((Object)atomName)))) {
            return false;
        }
        PdbAtomLine n3 = cytosine.findAtom(AtomName.N3);
        PdbAtomLine o2 = cytosine.findAtom(AtomName.O2);
        PdbAtomLine n4 = cytosine.findAtom(AtomName.N4);
        PdbAtomLine n1 = guanine.findAtom(AtomName.N1);
        PdbAtomLine n2 = guanine.findAtom(AtomName.N2);
        PdbAtomLine o6 = guanine.findAtom(AtomName.O6);
        double n3n1 = n3.distanceTo(n1);
        double o2n2 = o2.distanceTo(n2);
        double n4o6 = n4.distanceTo(o6);
        return n3n1 <= 3.22 && o2n2 <= 3.2199999999999998 && n4o6 <= 3.4699999999999998 && BasePair.isFacingYR(cytosine, guanine);
    }

    private static boolean isFacingYR(PdbResidue pyrimidine, PdbResidue purine) {
        Vector3D v2;
        if (Stream.of(AtomName.C6, AtomName.N3).anyMatch(atomName -> !pyrimidine.hasAtom((AtomName)((Object)atomName)))) {
            return false;
        }
        if (Stream.of(AtomName.C8, AtomName.N1).anyMatch(atomName -> !purine.hasAtom((AtomName)((Object)atomName)))) {
            return false;
        }
        PdbAtomLine c6 = pyrimidine.findAtom(AtomName.C6);
        PdbAtomLine n3 = pyrimidine.findAtom(AtomName.N3);
        PdbAtomLine c8 = purine.findAtom(AtomName.C8);
        PdbAtomLine n1 = purine.findAtom(AtomName.N1);
        Vector3D v1 = n3.toVector3D().subtract((Vector)c6.toVector3D());
        double dotProduct = v1.dotProduct((Vector)(v2 = n1.toVector3D().subtract((Vector)c8.toVector3D())));
        return dotProduct < 0.0;
    }

    @Value.Parameter(order=1)
    public abstract PdbNamedResidueIdentifier left();

    @Value.Parameter(order=2)
    public abstract PdbNamedResidueIdentifier right();

    public final BasePair invert() {
        return ImmutableBasePair.of(this.right(), this.left());
    }

    public final boolean is5to3() {
        return this.left().compareTo(this.right()) < 0;
    }

    public final String toString() {
        return this.left() + " - " + this.right();
    }

    @Override
    public final int compareTo(BasePair t) {
        return new CompareToBuilder().append((Object)this.left(), (Object)t.left()).append((Object)this.right(), (Object)t.right()).build();
    }
}

