/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.rna;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.biojava.nbio.structure.geometry.CalcPoint;
import org.biojava.nbio.structure.geometry.SuperPositions;
import org.biojava.nbio.structure.jama.Matrix;
import org.immutables.value.Value;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.rna.ImmutableStandardReferenceFrame;
import pl.poznan.put.rna.Nucleobase;
import pl.poznan.put.rna.Nucleotide;
import pl.poznan.put.rna.Purine;

@Value.Immutable
public abstract class StandardReferenceFrame {
    public static StandardReferenceFrame ofResidue(PdbResidue residue) {
        Nucleobase nucleobase = ((Nucleotide)residue.residueInformationProvider()).nucleobase();
        Map<AtomName, PdbAtomLine> frame = nucleobase.standardReferenceFrame();
        List order = frame.keySet().stream().sorted().collect(Collectors.toList());
        Point3d[] fixed = (Point3d[])frame.values().stream().sorted(Comparator.comparingInt(t -> order.indexOf((Object)t.detectAtomName()))).map(atom -> new Point3d(atom.x(), atom.y(), atom.z())).toArray(Point3d[]::new);
        Point3d[] moved = (Point3d[])residue.atoms().stream().filter(atom -> frame.containsKey((Object)atom.detectAtomName())).sorted(Comparator.comparingInt(t -> order.indexOf((Object)t.detectAtomName()))).map(atom -> new Point3d(atom.x(), atom.y(), atom.z())).toArray(Point3d[]::new);
        Point3d centroidFixed = CalcPoint.centroid((Point3d[])fixed);
        Point3d centroidMoved = CalcPoint.centroid((Point3d[])moved);
        Matrix4d superposition = SuperPositions.superpose((Point3d[])fixed, (Point3d[])moved);
        Matrix fixedMatrix = new Matrix((double[][])new double[][]{{centroidFixed.x, centroidFixed.y, centroidFixed.z}});
        Matrix movedMatrix = new Matrix((double[][])new double[][]{{centroidMoved.x, centroidMoved.y, centroidMoved.z}});
        Matrix rotationMatrix = new Matrix((double[][])new double[][]{{superposition.m00, superposition.m01, superposition.m02}, {superposition.m10, superposition.m11, superposition.m12}, {superposition.m20, superposition.m21, superposition.m22}});
        Vector3D origin = new Vector3D(movedMatrix.minus(fixedMatrix.times(rotationMatrix)).getRowPackedCopy());
        Vector3D x = new Vector3D(superposition.m00, superposition.m01, superposition.m02);
        Vector3D y = new Vector3D(superposition.m10, superposition.m11, superposition.m12);
        Vector3D z = new Vector3D(superposition.m20, superposition.m21, superposition.m22);
        PdbAtomLine longAxisAtom = nucleobase instanceof Purine ? residue.findAtom(AtomName.C8) : residue.findAtom(AtomName.C6);
        return ImmutableStandardReferenceFrame.of(origin, x, y, z).withLongAxisAtom(Optional.of(longAxisAtom));
    }

    public static StandardReferenceFrame ofBasePair(StandardReferenceFrame primary, StandardReferenceFrame secondary) {
        String message = "Cannot build reference frame without knowing the long axis atom";
        PdbAtomLine primaryAtom = primary.longAxisAtom().orElseThrow(() -> new IllegalArgumentException("Cannot build reference frame without knowing the long axis atom"));
        PdbAtomLine secondaryAtom = secondary.longAxisAtom().orElseThrow(() -> new IllegalArgumentException("Cannot build reference frame without knowing the long axis atom"));
        Vector3D z = new Vector3D(IntStream.range(0, 3).mapToDouble(i -> primary.z().toArray()[i] + secondary.z().toArray()[i]).map(v -> v / 2.0).toArray()).normalize();
        Vector3D y = secondaryAtom.toVector3D().subtract((Vector)primaryAtom.toVector3D()).orthogonal().crossProduct((Vector)z).normalize();
        Vector3D x = y.crossProduct((Vector)z).normalize();
        Vector3D origin = primary.origin().subtract((Vector)secondary.origin());
        return ImmutableStandardReferenceFrame.of(origin, x, y, z);
    }

    @Value.Parameter(order=1)
    public abstract Vector3D origin();

    @Value.Parameter(order=2)
    public abstract Vector3D x();

    @Value.Parameter(order=3)
    public abstract Vector3D y();

    @Value.Parameter(order=4)
    public abstract Vector3D z();

    @Value.Default
    public Optional<PdbAtomLine> longAxisAtom() {
        return Optional.empty();
    }
}

