/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.rna;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.notation.NucleobaseEdge;
import pl.poznan.put.rna.Chi;
import pl.poznan.put.rna.Nucleobase;
import pl.poznan.put.rna.NucleotideTorsionAngle;
import pl.poznan.put.torsion.TorsionAngleType;

public interface Pyrimidine
extends Nucleobase {
    @Override
    default public Pair<AtomName, AtomName> edgeVectorAtoms(NucleobaseEdge edge) {
        switch (edge) {
            case WATSON_CRICK: {
                return Pair.of((Object)((Object)AtomName.C6), (Object)((Object)AtomName.N3));
            }
            case HOOGSTEEN: {
                return Pair.of((Object)((Object)AtomName.C2), (Object)((Object)AtomName.C5));
            }
            case SUGAR: {
                return Pair.of((Object)((Object)AtomName.C4), (Object)((Object)AtomName.C2));
            }
        }
        throw new IllegalArgumentException("Invalid nucleobase edge: " + (Object)((Object)edge));
    }

    @Override
    default public List<TorsionAngleType> torsionAngleTypes() {
        return Stream.of(NucleotideTorsionAngle.ALPHA.angleTypes().get(0), NucleotideTorsionAngle.BETA.angleTypes().get(0), NucleotideTorsionAngle.GAMMA.angleTypes().get(0), NucleotideTorsionAngle.DELTA.angleTypes().get(0), NucleotideTorsionAngle.EPSILON.angleTypes().get(0), NucleotideTorsionAngle.ZETA.angleTypes().get(0), NucleotideTorsionAngle.NU0.angleTypes().get(0), NucleotideTorsionAngle.NU1.angleTypes().get(0), NucleotideTorsionAngle.NU2.angleTypes().get(0), NucleotideTorsionAngle.NU3.angleTypes().get(0), NucleotideTorsionAngle.NU4.angleTypes().get(0), NucleotideTorsionAngle.ETA.angleTypes().get(0), NucleotideTorsionAngle.THETA.angleTypes().get(0), NucleotideTorsionAngle.ETA_PRIM.angleTypes().get(0), NucleotideTorsionAngle.THETA_PRIM.angleTypes().get(0), NucleotideTorsionAngle.PSEUDOPHASE_PUCKER.angleTypes().get(0), Chi.PYRIMIDINE.angleType()).collect(Collectors.toList());
    }
}

