/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.rna;

import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.circular.ImmutableAngle;
import pl.poznan.put.torsion.range.Range;
import pl.poznan.put.torsion.range.RangeDifference;
import pl.poznan.put.torsion.range.RangeProvider;

public enum Pseudorotation implements Range
{
    TWIST_3_2("C2'-exo-C3'-endo", 0.0),
    ENVELOPE_3_ENDO("C3'-endo", 18.0),
    TWIST_3_4("C3'-endo-C4'-exo", 36.0),
    ENVELOPE_4_EXO("C4'-exo", 54.0),
    TWIST_O_4("C4'-exo-O4'-endo", 72.0),
    ENVELOPE_O_ENDO("O4'-endo", 90.0),
    TWIST_O_1("O4'-endo-C1'-exo", 108.0),
    ENVELOPE_1_EXO("C1'-exo", 126.0),
    TWIST_2_1("C1'-exo-C2'-endo", 144.0),
    ENVELOPE_2_ENDO("C2'-endo", 162.0),
    TWIST_2_3("C2'-endo-C3'-exo", 180.0),
    ENVELOPE_3_EXO("C3'-exo", 198.0),
    TWIST_4_3("C3'-exo-C4'-endo", 216.0),
    ENVELOPE_4_ENDO("C4'-endo", 234.0),
    TWIST_4_O("C4'-endo-O4'-exo", 252.0),
    ENVELOPE_O_EXO("O4'-exo", 270.0),
    TWIST_1_O("O4'-exo-C1'-endo", 288.0),
    ENVELOPE_1_ENDO("C1'-endo", 306.0),
    TWIST_1_2("C1'-endo-C2'-exo", 324.0),
    ENVELOPE_2_EXO("C2'-exo", 342.0),
    INVALID("invalid", Double.NaN);

    private final String displayName;
    private final Angle begin;
    private final Angle end;

    private Pseudorotation(String displayName, double degrees) {
        this.displayName = displayName;
        this.begin = ImmutableAngle.of(FastMath.toRadians((double)(degrees - 9.0)));
        this.end = ImmutableAngle.of(FastMath.toRadians((double)(degrees + 9.0)));
    }

    public static RangeProvider getProvider() {
        return angle -> Arrays.stream(Pseudorotation.values()).filter(candidate -> angle.isBetween(candidate.begin, candidate.end)).findFirst().orElse(INVALID);
    }

    @Override
    public String displayName() {
        return this.displayName;
    }

    @Override
    public Angle begin() {
        return this.begin;
    }

    @Override
    public Angle end() {
        return this.end;
    }

    @Override
    public RangeDifference compare(Range other) {
        if (!(other instanceof Pseudorotation)) {
            throw new IllegalArgumentException("A Pseudorotation object can be compared only with other Pseudorotation object");
        }
        if (this == INVALID || other == INVALID) {
            return RangeDifference.INVALID;
        }
        if (this == other) {
            return RangeDifference.EQUAL;
        }
        double difference = this.begin.subtract(other.begin()).degrees();
        if (difference > 90.0) {
            difference = 180.0 - difference;
        }
        if (difference <= 36.0) {
            return RangeDifference.SIMILAR;
        }
        if (difference <= 72.0) {
            return RangeDifference.DIFFERENT;
        }
        return RangeDifference.OPPOSITE;
    }
}

