/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.rna;

import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.math3.util.FastMath;
import org.immutables.value.Value;
import pl.poznan.put.circular.ImmutableAngle;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.rna.NucleotideTorsionAngle;
import pl.poznan.put.torsion.ImmutableTorsionAngleValue;
import pl.poznan.put.torsion.TorsionAngleType;
import pl.poznan.put.torsion.TorsionAngleValue;

@Value.Immutable(singleton=true)
public abstract class PseudophasePuckerType
implements TorsionAngleType {
    @Override
    public final String shortDisplayName() {
        return "P";
    }

    @Override
    public final String longDisplayName() {
        return "P";
    }

    @Override
    public final String exportName() {
        return "P";
    }

    @Override
    public final MoleculeType moleculeType() {
        return MoleculeType.RNA;
    }

    @Override
    public final TorsionAngleValue calculate(List<PdbResidue> residues, int currentIndex) {
        TorsionAngleValue nu0 = NucleotideTorsionAngle.NU0.angleTypes().get(0).calculate(residues, currentIndex);
        TorsionAngleValue nu1 = NucleotideTorsionAngle.NU1.angleTypes().get(0).calculate(residues, currentIndex);
        TorsionAngleValue nu2 = NucleotideTorsionAngle.NU2.angleTypes().get(0).calculate(residues, currentIndex);
        TorsionAngleValue nu3 = NucleotideTorsionAngle.NU3.angleTypes().get(0).calculate(residues, currentIndex);
        TorsionAngleValue nu4 = NucleotideTorsionAngle.NU4.angleTypes().get(0).calculate(residues, currentIndex);
        if (Stream.of(nu0, nu1, nu2, nu3, nu4).map(TorsionAngleValue::value).anyMatch(angle -> !angle.isValid())) {
            return ImmutableTorsionAngleValue.of(this, ImmutableAngle.of(Double.NaN));
        }
        double scale = 2.0 * (FastMath.sin((double)FastMath.toRadians((double)36.0)) + FastMath.sin((double)FastMath.toRadians((double)72.0)));
        double y = nu1.value().radians() + nu4.value().radians() - (nu0.value().radians() + nu3.value().radians());
        double x = nu2.value().radians() * scale;
        return ImmutableTorsionAngleValue.of(this, ImmutableAngle.of(FastMath.atan2((double)y, (double)x)));
    }
}

