/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.rna;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.rna.Chi;
import pl.poznan.put.rna.ChiRange;
import pl.poznan.put.rna.ImmutablePseudophasePuckerType;
import pl.poznan.put.rna.Pseudorotation;
import pl.poznan.put.torsion.ImmutableAtomBasedTorsionAngleType;
import pl.poznan.put.torsion.MasterTorsionAngleType;
import pl.poznan.put.torsion.TorsionAngleType;
import pl.poznan.put.torsion.range.Range;
import pl.poznan.put.torsion.range.RangeProvider;
import pl.poznan.put.torsion.range.TorsionRange;
import pl.poznan.put.types.ImmutableQuadruple;

public final class NucleotideTorsionAngle
extends Enum<NucleotideTorsionAngle>
implements MasterTorsionAngleType {
    public static final /* enum */ NucleotideTorsionAngle ALPHA = new NucleotideTorsionAngle(ImmutableAtomBasedTorsionAngleType.of(MoleculeType.RNA, "\u03b1", "alpha", ImmutableQuadruple.of(AtomName.O3p, AtomName.P, AtomName.O5p, AtomName.C5p), ImmutableQuadruple.of(-1, 0, 0, 0)));
    public static final /* enum */ NucleotideTorsionAngle BETA = new NucleotideTorsionAngle(ImmutableAtomBasedTorsionAngleType.of(MoleculeType.RNA, "\u03b2", "beta", ImmutableQuadruple.of(AtomName.P, AtomName.O5p, AtomName.C5p, AtomName.C4p), ImmutableQuadruple.of(0, 0, 0, 0)));
    public static final /* enum */ NucleotideTorsionAngle GAMMA = new NucleotideTorsionAngle(ImmutableAtomBasedTorsionAngleType.of(MoleculeType.RNA, "\u03b3", "gamma", ImmutableQuadruple.of(AtomName.O5p, AtomName.C5p, AtomName.C4p, AtomName.C3p), ImmutableQuadruple.of(0, 0, 0, 0)));
    public static final /* enum */ NucleotideTorsionAngle DELTA = new NucleotideTorsionAngle(ImmutableAtomBasedTorsionAngleType.of(MoleculeType.RNA, "\u03b4", "delta", ImmutableQuadruple.of(AtomName.C5p, AtomName.C4p, AtomName.C3p, AtomName.O3p), ImmutableQuadruple.of(0, 0, 0, 0)));
    public static final /* enum */ NucleotideTorsionAngle EPSILON = new NucleotideTorsionAngle(ImmutableAtomBasedTorsionAngleType.of(MoleculeType.RNA, "\u03b5", "epsilon", ImmutableQuadruple.of(AtomName.C4p, AtomName.C3p, AtomName.O3p, AtomName.P), ImmutableQuadruple.of(0, 0, 0, 1)));
    public static final /* enum */ NucleotideTorsionAngle ZETA = new NucleotideTorsionAngle(ImmutableAtomBasedTorsionAngleType.of(MoleculeType.RNA, "\u03b6", "zeta", ImmutableQuadruple.of(AtomName.C3p, AtomName.O3p, AtomName.P, AtomName.O5p), ImmutableQuadruple.of(0, 0, 1, 1)));
    public static final /* enum */ NucleotideTorsionAngle NU0 = new NucleotideTorsionAngle(ImmutableAtomBasedTorsionAngleType.of(MoleculeType.RNA, "\u03bd0", "nu0", ImmutableQuadruple.of(AtomName.C4p, AtomName.O4p, AtomName.C1p, AtomName.C2p), ImmutableQuadruple.of(0, 0, 0, 0)));
    public static final /* enum */ NucleotideTorsionAngle NU1 = new NucleotideTorsionAngle(ImmutableAtomBasedTorsionAngleType.of(MoleculeType.RNA, "\u03bd1", "nu1", ImmutableQuadruple.of(AtomName.O4p, AtomName.C1p, AtomName.C2p, AtomName.C3p), ImmutableQuadruple.of(0, 0, 0, 0)));
    public static final /* enum */ NucleotideTorsionAngle NU2 = new NucleotideTorsionAngle(ImmutableAtomBasedTorsionAngleType.of(MoleculeType.RNA, "\u03bd2", "nu2", ImmutableQuadruple.of(AtomName.C1p, AtomName.C2p, AtomName.C3p, AtomName.C4p), ImmutableQuadruple.of(0, 0, 0, 0)));
    public static final /* enum */ NucleotideTorsionAngle NU3 = new NucleotideTorsionAngle(ImmutableAtomBasedTorsionAngleType.of(MoleculeType.RNA, "\u03bd3", "nu3", ImmutableQuadruple.of(AtomName.C2p, AtomName.C3p, AtomName.C4p, AtomName.O4p), ImmutableQuadruple.of(0, 0, 0, 0)));
    public static final /* enum */ NucleotideTorsionAngle NU4 = new NucleotideTorsionAngle(ImmutableAtomBasedTorsionAngleType.of(MoleculeType.RNA, "\u03bd4", "nu4", ImmutableQuadruple.of(AtomName.C3p, AtomName.C4p, AtomName.O4p, AtomName.C1p), ImmutableQuadruple.of(0, 0, 0, 0)));
    public static final /* enum */ NucleotideTorsionAngle ETA = new NucleotideTorsionAngle(ImmutableAtomBasedTorsionAngleType.builder().moleculeType(MoleculeType.RNA).shortDisplayName("\u03b7").exportName("eta").atoms(ImmutableQuadruple.of(AtomName.C4p, AtomName.P, AtomName.C4p, AtomName.P)).residueRule(ImmutableQuadruple.of(-1, 0, 0, 1)).isPseudoTorsion(true).build());
    public static final /* enum */ NucleotideTorsionAngle THETA = new NucleotideTorsionAngle(ImmutableAtomBasedTorsionAngleType.builder().moleculeType(MoleculeType.RNA).shortDisplayName("\u03b8").exportName("theta").atoms(ImmutableQuadruple.of(AtomName.P, AtomName.C4p, AtomName.P, AtomName.C4p)).residueRule(ImmutableQuadruple.of(0, 0, 1, 1)).isPseudoTorsion(true).build());
    public static final /* enum */ NucleotideTorsionAngle ETA_PRIM = new NucleotideTorsionAngle(ImmutableAtomBasedTorsionAngleType.builder().moleculeType(MoleculeType.RNA).shortDisplayName("\u03b7'").exportName("eta-prim").atoms(ImmutableQuadruple.of(AtomName.C1p, AtomName.P, AtomName.C1p, AtomName.P)).residueRule(ImmutableQuadruple.of(-1, 0, 0, 1)).isPseudoTorsion(true).build());
    public static final /* enum */ NucleotideTorsionAngle THETA_PRIM = new NucleotideTorsionAngle(ImmutableAtomBasedTorsionAngleType.builder().moleculeType(MoleculeType.RNA).shortDisplayName("\u03b8'").exportName("theta-prim").atoms(ImmutableQuadruple.of(AtomName.P, AtomName.C1p, AtomName.P, AtomName.C1p)).residueRule(ImmutableQuadruple.of(0, 0, 1, 1)).isPseudoTorsion(true).build());
    public static final /* enum */ NucleotideTorsionAngle CHI = new NucleotideTorsionAngle(ChiRange.getProvider(), Chi.PURINE.angleType(), Chi.PYRIMIDINE.angleType());
    public static final /* enum */ NucleotideTorsionAngle PSEUDOPHASE_PUCKER = new NucleotideTorsionAngle(Pseudorotation.getProvider(), ImmutablePseudophasePuckerType.of());
    private final RangeProvider rangeProvider;
    private final List<TorsionAngleType> angleTypes;
    private static final /* synthetic */ NucleotideTorsionAngle[] $VALUES;

    public static NucleotideTorsionAngle[] values() {
        return (NucleotideTorsionAngle[])$VALUES.clone();
    }

    public static NucleotideTorsionAngle valueOf(String name) {
        return Enum.valueOf(NucleotideTorsionAngle.class, name);
    }

    private NucleotideTorsionAngle(TorsionAngleType ... angleTypes) {
        this(TorsionRange.rangeProvider(), angleTypes);
    }

    private NucleotideTorsionAngle(RangeProvider rangeProvider, TorsionAngleType ... angleTypes) {
        this.rangeProvider = rangeProvider;
        this.angleTypes = Arrays.asList(angleTypes);
    }

    @Override
    public List<TorsionAngleType> angleTypes() {
        return Collections.unmodifiableList(this.angleTypes);
    }

    @Override
    public Range range(Angle angle) {
        return this.rangeProvider.fromAngle(angle);
    }

    @Override
    public String shortDisplayName() {
        assert (!this.angleTypes.isEmpty());
        return this.angleTypes.get(0).shortDisplayName();
    }

    @Override
    public String longDisplayName() {
        assert (!this.angleTypes.isEmpty());
        return this.angleTypes.get(0).longDisplayName();
    }

    @Override
    public String exportName() {
        assert (!this.angleTypes.isEmpty());
        return this.angleTypes.get(0).exportName();
    }

    static {
        $VALUES = new NucleotideTorsionAngle[]{ALPHA, BETA, GAMMA, DELTA, EPSILON, ZETA, NU0, NU1, NU2, NU3, NU4, ETA, THETA, ETA_PRIM, THETA_PRIM, CHI, PSEUDOPHASE_PUCKER};
    }
}

