/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.rna;

import java.util.List;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.pdb.analysis.ResidueComponent;
import pl.poznan.put.pdb.analysis.ResidueInformationProvider;
import pl.poznan.put.rna.ImmutableAdenine;
import pl.poznan.put.rna.ImmutableCytosine;
import pl.poznan.put.rna.ImmutableGuanine;
import pl.poznan.put.rna.ImmutableThymine;
import pl.poznan.put.rna.ImmutableUracil;
import pl.poznan.put.rna.Nucleobase;
import pl.poznan.put.torsion.TorsionAngleType;

public enum Nucleotide implements ResidueInformationProvider
{
    ADENINE(ImmutableAdenine.of()),
    CYTOSINE(ImmutableCytosine.of()),
    GUANINE(ImmutableGuanine.of()),
    URACIL(ImmutableUracil.of()),
    THYMINE(ImmutableThymine.of());

    private final Nucleobase nucleobase;

    private Nucleotide(Nucleobase nucleobase) {
        this.nucleobase = nucleobase;
    }

    public Nucleobase nucleobase() {
        return this.nucleobase;
    }

    @Override
    public MoleculeType moleculeType() {
        return MoleculeType.RNA;
    }

    @Override
    public List<ResidueComponent> moleculeComponents() {
        return this.nucleobase.moleculeComponents();
    }

    @Override
    public char oneLetterName() {
        return this.nucleobase.oneLetterName();
    }

    @Override
    public List<String> aliases() {
        return this.nucleobase.aliases();
    }

    @Override
    public List<TorsionAngleType> torsionAngleTypes() {
        return this.nucleobase.torsionAngleTypes();
    }
}

