/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.rna;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.notation.NucleobaseEdge;
import pl.poznan.put.pdb.ImmutablePdbAtomLine;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.pdb.analysis.ResidueInformationProvider;
import pl.poznan.put.rna.NucleicAcidResidueComponent;
import pl.poznan.put.rna.NucleotideComponentType;

public interface Nucleobase
extends NucleicAcidResidueComponent,
ResidueInformationProvider {
    public String standardReferenceFrameString();

    public Pair<AtomName, AtomName> edgeVectorAtoms(NucleobaseEdge var1);

    default public Map<AtomName, PdbAtomLine> standardReferenceFrame() {
        return Arrays.stream(StringUtils.split((String)this.standardReferenceFrameString(), (char)'\n')).map(StringUtils::split).map(fields -> ImmutablePdbAtomLine.of(Integer.parseInt(fields[1]), fields[2], " ", fields[4], "A", 1, " ", Double.parseDouble(fields[4]), Double.parseDouble(fields[5]), Double.parseDouble(fields[6]), 0.0, 0.0, " ", " ")).collect(Collectors.toMap(PdbAtomLine::detectAtomName, Function.identity()));
    }

    default public Vector3D edgeVector(PdbResidue residue, NucleobaseEdge edge) {
        Pair<AtomName, AtomName> pair = this.edgeVectorAtoms(edge);
        return residue.findAtom((AtomName)((Object)pair.getRight())).toVector3D().subtract((Vector)residue.findAtom((AtomName)((Object)pair.getLeft())).toVector3D());
    }

    @Override
    default public MoleculeType moleculeType() {
        return MoleculeType.RNA;
    }

    @Override
    default public NucleotideComponentType nucleotideComponentType() {
        return NucleotideComponentType.BASE;
    }
}

