/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.rna;

import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;
import pl.poznan.put.rna.ImmutableInteractionType;
import pl.poznan.put.rna.NucleotideComponentType;

@Value.Immutable
public abstract class InteractionType
implements Serializable,
Comparable<InteractionType> {
    public static final InteractionType BASE_BASE = ImmutableInteractionType.builder().left(NucleotideComponentType.BASE).right(NucleotideComponentType.BASE).isPairing(true).build();
    public static final InteractionType BASE_BASE_1H = ImmutableInteractionType.builder().left(NucleotideComponentType.BASE).right(NucleotideComponentType.BASE).isPairing(false).description("base - base (1H)").build();
    public static final InteractionType BASE_PHOSPHATE = ImmutableInteractionType.builder().left(NucleotideComponentType.BASE).right(NucleotideComponentType.PHOSPHATE).isPairing(false).build();
    public static final InteractionType BASE_RIBOSE = ImmutableInteractionType.builder().left(NucleotideComponentType.BASE).right(NucleotideComponentType.RIBOSE).isPairing(false).build();
    public static final InteractionType SUGAR_SUGAR = ImmutableInteractionType.builder().left(NucleotideComponentType.RIBOSE).right(NucleotideComponentType.RIBOSE).isPairing(false).build();
    public static final InteractionType STACKING = ImmutableInteractionType.builder().left(NucleotideComponentType.BASE).right(NucleotideComponentType.BASE).isPairing(false).description("stacking").build();
    public static final InteractionType OTHER = ImmutableInteractionType.builder().left(NucleotideComponentType.UNKNOWN).right(NucleotideComponentType.UNKNOWN).isPairing(false).description("other").build();

    private static int fragmentInternalValue(NucleotideComponentType type) {
        switch (type) {
            case BASE: {
                return 1;
            }
            case RIBOSE: {
                return 10;
            }
            case PHOSPHATE: {
                return 100;
            }
        }
        return 1000;
    }

    public abstract NucleotideComponentType left();

    public abstract NucleotideComponentType right();

    public abstract boolean isPairing();

    @Value.Default
    public String description() {
        return StringUtils.lowerCase((String)String.format("%s - %s", new Object[]{this.right(), this.left()}), (Locale)Locale.US);
    }

    public final String toString() {
        return this.description();
    }

    @Override
    public final int compareTo(InteractionType t) {
        return Integer.compare(this.internalValue(), t.internalValue());
    }

    public final InteractionType invert() {
        return ImmutableInteractionType.builder().left(this.right()).right(this.left()).isPairing(this.isPairing()).build();
    }

    private int internalValue() {
        if (this.equals(STACKING)) {
            return Integer.MAX_VALUE;
        }
        int value = 0;
        value += InteractionType.fragmentInternalValue(this.left());
        value += InteractionType.fragmentInternalValue(this.right());
        if (this.isPairing()) {
            value = -value;
        }
        return value;
    }
}

