/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.rna;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.rna.StandardReferenceFrame;

@ParametersAreNonnullByDefault
@Generated(from="StandardReferenceFrame", generator="Immutables")
@Immutable
public final class ImmutableStandardReferenceFrame
extends StandardReferenceFrame {
    private final Vector3D origin;
    private final Vector3D x;
    private final Vector3D y;
    private final Vector3D z;
    private final Optional<PdbAtomLine> longAxisAtom;

    private ImmutableStandardReferenceFrame(Vector3D origin, Vector3D x, Vector3D y, Vector3D z) {
        this.origin = Objects.requireNonNull(origin, "origin");
        this.x = Objects.requireNonNull(x, "x");
        this.y = Objects.requireNonNull(y, "y");
        this.z = Objects.requireNonNull(z, "z");
        this.longAxisAtom = Objects.requireNonNull(super.longAxisAtom(), "longAxisAtom");
    }

    private ImmutableStandardReferenceFrame(Builder builder) {
        this.origin = builder.origin;
        this.x = builder.x;
        this.y = builder.y;
        this.z = builder.z;
        this.longAxisAtom = builder.longAxisAtom != null ? builder.longAxisAtom : Objects.requireNonNull(super.longAxisAtom(), "longAxisAtom");
    }

    private ImmutableStandardReferenceFrame(Vector3D origin, Vector3D x, Vector3D y, Vector3D z, Optional<PdbAtomLine> longAxisAtom) {
        this.origin = origin;
        this.x = x;
        this.y = y;
        this.z = z;
        this.longAxisAtom = longAxisAtom;
    }

    @Override
    public Vector3D origin() {
        return this.origin;
    }

    @Override
    public Vector3D x() {
        return this.x;
    }

    @Override
    public Vector3D y() {
        return this.y;
    }

    @Override
    public Vector3D z() {
        return this.z;
    }

    @Override
    public Optional<PdbAtomLine> longAxisAtom() {
        return this.longAxisAtom;
    }

    public final ImmutableStandardReferenceFrame withOrigin(Vector3D value) {
        if (this.origin == value) {
            return this;
        }
        Vector3D newValue = Objects.requireNonNull(value, "origin");
        return new ImmutableStandardReferenceFrame(newValue, this.x, this.y, this.z, this.longAxisAtom);
    }

    public final ImmutableStandardReferenceFrame withX(Vector3D value) {
        if (this.x == value) {
            return this;
        }
        Vector3D newValue = Objects.requireNonNull(value, "x");
        return new ImmutableStandardReferenceFrame(this.origin, newValue, this.y, this.z, this.longAxisAtom);
    }

    public final ImmutableStandardReferenceFrame withY(Vector3D value) {
        if (this.y == value) {
            return this;
        }
        Vector3D newValue = Objects.requireNonNull(value, "y");
        return new ImmutableStandardReferenceFrame(this.origin, this.x, newValue, this.z, this.longAxisAtom);
    }

    public final ImmutableStandardReferenceFrame withZ(Vector3D value) {
        if (this.z == value) {
            return this;
        }
        Vector3D newValue = Objects.requireNonNull(value, "z");
        return new ImmutableStandardReferenceFrame(this.origin, this.x, this.y, newValue, this.longAxisAtom);
    }

    public final ImmutableStandardReferenceFrame withLongAxisAtom(Optional<PdbAtomLine> value) {
        Optional<PdbAtomLine> newValue = Objects.requireNonNull(value, "longAxisAtom");
        if (this.longAxisAtom.equals(newValue)) {
            return this;
        }
        return new ImmutableStandardReferenceFrame(this.origin, this.x, this.y, this.z, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStandardReferenceFrame && this.equalTo((ImmutableStandardReferenceFrame)another);
    }

    private boolean equalTo(ImmutableStandardReferenceFrame another) {
        return this.origin.equals((Object)another.origin) && this.x.equals((Object)another.x) && this.y.equals((Object)another.y) && this.z.equals((Object)another.z) && this.longAxisAtom.equals(another.longAxisAtom);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.origin.hashCode();
        h += (h << 5) + this.x.hashCode();
        h += (h << 5) + this.y.hashCode();
        h += (h << 5) + this.z.hashCode();
        h += (h << 5) + this.longAxisAtom.hashCode();
        return h;
    }

    public String toString() {
        return "StandardReferenceFrame{origin=" + this.origin + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", longAxisAtom=" + this.longAxisAtom + "}";
    }

    public static ImmutableStandardReferenceFrame of(Vector3D origin, Vector3D x, Vector3D y, Vector3D z) {
        return new ImmutableStandardReferenceFrame(origin, x, y, z);
    }

    public static ImmutableStandardReferenceFrame copyOf(StandardReferenceFrame instance) {
        if (instance instanceof ImmutableStandardReferenceFrame) {
            return (ImmutableStandardReferenceFrame)instance;
        }
        return ImmutableStandardReferenceFrame.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StandardReferenceFrame", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ORIGIN = 1L;
        private static final long INIT_BIT_X = 2L;
        private static final long INIT_BIT_Y = 4L;
        private static final long INIT_BIT_Z = 8L;
        private long initBits = 15L;
        @Nullable
        private Vector3D origin;
        @Nullable
        private Vector3D x;
        @Nullable
        private Vector3D y;
        @Nullable
        private Vector3D z;
        @Nullable
        private Optional<PdbAtomLine> longAxisAtom;

        private Builder() {
        }

        public final Builder from(StandardReferenceFrame instance) {
            Objects.requireNonNull(instance, "instance");
            this.origin(instance.origin());
            this.x(instance.x());
            this.y(instance.y());
            this.z(instance.z());
            this.longAxisAtom(instance.longAxisAtom());
            return this;
        }

        public final Builder origin(Vector3D origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder x(Vector3D x) {
            this.x = Objects.requireNonNull(x, "x");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder y(Vector3D y) {
            this.y = Objects.requireNonNull(y, "y");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder z(Vector3D z) {
            this.z = Objects.requireNonNull(z, "z");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder longAxisAtom(Optional<PdbAtomLine> longAxisAtom) {
            this.longAxisAtom = Objects.requireNonNull(longAxisAtom, "longAxisAtom");
            return this;
        }

        public ImmutableStandardReferenceFrame build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStandardReferenceFrame(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("origin");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("x");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("y");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("z");
            }
            return "Cannot build StandardReferenceFrame, some of required attributes are not set " + attributes;
        }
    }
}

