/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.rna;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.rna.BasePairParameters;

@ParametersAreNonnullByDefault
@Generated(from="BasePairParameters", generator="Immutables")
@Immutable
public final class ImmutableBasePairParameters
extends BasePairParameters {
    private final double shear;
    private final double stretch;
    private final double stagger;
    private final Angle buckle;
    private final Angle propeller;
    private final Angle opening;
    private final Angle interBaseAngle;

    private ImmutableBasePairParameters(double shear, double stretch, double stagger, Angle buckle, Angle propeller, Angle opening, Angle interBaseAngle) {
        this.shear = shear;
        this.stretch = stretch;
        this.stagger = stagger;
        this.buckle = Objects.requireNonNull(buckle, "buckle");
        this.propeller = Objects.requireNonNull(propeller, "propeller");
        this.opening = Objects.requireNonNull(opening, "opening");
        this.interBaseAngle = Objects.requireNonNull(interBaseAngle, "interBaseAngle");
    }

    private ImmutableBasePairParameters(ImmutableBasePairParameters original, double shear, double stretch, double stagger, Angle buckle, Angle propeller, Angle opening, Angle interBaseAngle) {
        this.shear = shear;
        this.stretch = stretch;
        this.stagger = stagger;
        this.buckle = buckle;
        this.propeller = propeller;
        this.opening = opening;
        this.interBaseAngle = interBaseAngle;
    }

    @Override
    public double shear() {
        return this.shear;
    }

    @Override
    public double stretch() {
        return this.stretch;
    }

    @Override
    public double stagger() {
        return this.stagger;
    }

    @Override
    public Angle buckle() {
        return this.buckle;
    }

    @Override
    public Angle propeller() {
        return this.propeller;
    }

    @Override
    public Angle opening() {
        return this.opening;
    }

    @Override
    public Angle interBaseAngle() {
        return this.interBaseAngle;
    }

    public final ImmutableBasePairParameters withShear(double value) {
        if (Double.doubleToLongBits(this.shear) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableBasePairParameters(this, value, this.stretch, this.stagger, this.buckle, this.propeller, this.opening, this.interBaseAngle);
    }

    public final ImmutableBasePairParameters withStretch(double value) {
        if (Double.doubleToLongBits(this.stretch) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableBasePairParameters(this, this.shear, value, this.stagger, this.buckle, this.propeller, this.opening, this.interBaseAngle);
    }

    public final ImmutableBasePairParameters withStagger(double value) {
        if (Double.doubleToLongBits(this.stagger) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableBasePairParameters(this, this.shear, this.stretch, value, this.buckle, this.propeller, this.opening, this.interBaseAngle);
    }

    public final ImmutableBasePairParameters withBuckle(Angle value) {
        if (this.buckle == value) {
            return this;
        }
        Angle newValue = Objects.requireNonNull(value, "buckle");
        return new ImmutableBasePairParameters(this, this.shear, this.stretch, this.stagger, newValue, this.propeller, this.opening, this.interBaseAngle);
    }

    public final ImmutableBasePairParameters withPropeller(Angle value) {
        if (this.propeller == value) {
            return this;
        }
        Angle newValue = Objects.requireNonNull(value, "propeller");
        return new ImmutableBasePairParameters(this, this.shear, this.stretch, this.stagger, this.buckle, newValue, this.opening, this.interBaseAngle);
    }

    public final ImmutableBasePairParameters withOpening(Angle value) {
        if (this.opening == value) {
            return this;
        }
        Angle newValue = Objects.requireNonNull(value, "opening");
        return new ImmutableBasePairParameters(this, this.shear, this.stretch, this.stagger, this.buckle, this.propeller, newValue, this.interBaseAngle);
    }

    public final ImmutableBasePairParameters withInterBaseAngle(Angle value) {
        if (this.interBaseAngle == value) {
            return this;
        }
        Angle newValue = Objects.requireNonNull(value, "interBaseAngle");
        return new ImmutableBasePairParameters(this, this.shear, this.stretch, this.stagger, this.buckle, this.propeller, this.opening, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBasePairParameters && this.equalTo((ImmutableBasePairParameters)another);
    }

    private boolean equalTo(ImmutableBasePairParameters another) {
        return Double.doubleToLongBits(this.shear) == Double.doubleToLongBits(another.shear) && Double.doubleToLongBits(this.stretch) == Double.doubleToLongBits(another.stretch) && Double.doubleToLongBits(this.stagger) == Double.doubleToLongBits(another.stagger) && this.buckle.equals(another.buckle) && this.propeller.equals(another.propeller) && this.opening.equals(another.opening) && this.interBaseAngle.equals(another.interBaseAngle);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Double.hashCode(this.shear);
        h += (h << 5) + Double.hashCode(this.stretch);
        h += (h << 5) + Double.hashCode(this.stagger);
        h += (h << 5) + this.buckle.hashCode();
        h += (h << 5) + this.propeller.hashCode();
        h += (h << 5) + this.opening.hashCode();
        h += (h << 5) + this.interBaseAngle.hashCode();
        return h;
    }

    public String toString() {
        return "BasePairParameters{shear=" + this.shear + ", stretch=" + this.stretch + ", stagger=" + this.stagger + ", buckle=" + this.buckle + ", propeller=" + this.propeller + ", opening=" + this.opening + ", interBaseAngle=" + this.interBaseAngle + "}";
    }

    public static ImmutableBasePairParameters of(double shear, double stretch, double stagger, Angle buckle, Angle propeller, Angle opening, Angle interBaseAngle) {
        return new ImmutableBasePairParameters(shear, stretch, stagger, buckle, propeller, opening, interBaseAngle);
    }

    public static ImmutableBasePairParameters copyOf(BasePairParameters instance) {
        if (instance instanceof ImmutableBasePairParameters) {
            return (ImmutableBasePairParameters)instance;
        }
        return ImmutableBasePairParameters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BasePairParameters", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SHEAR = 1L;
        private static final long INIT_BIT_STRETCH = 2L;
        private static final long INIT_BIT_STAGGER = 4L;
        private static final long INIT_BIT_BUCKLE = 8L;
        private static final long INIT_BIT_PROPELLER = 16L;
        private static final long INIT_BIT_OPENING = 32L;
        private static final long INIT_BIT_INTER_BASE_ANGLE = 64L;
        private long initBits = 127L;
        private double shear;
        private double stretch;
        private double stagger;
        @Nullable
        private Angle buckle;
        @Nullable
        private Angle propeller;
        @Nullable
        private Angle opening;
        @Nullable
        private Angle interBaseAngle;

        private Builder() {
        }

        public final Builder from(BasePairParameters instance) {
            Objects.requireNonNull(instance, "instance");
            this.shear(instance.shear());
            this.stretch(instance.stretch());
            this.stagger(instance.stagger());
            this.buckle(instance.buckle());
            this.propeller(instance.propeller());
            this.opening(instance.opening());
            this.interBaseAngle(instance.interBaseAngle());
            return this;
        }

        public final Builder shear(double shear) {
            this.shear = shear;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder stretch(double stretch) {
            this.stretch = stretch;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder stagger(double stagger) {
            this.stagger = stagger;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder buckle(Angle buckle) {
            this.buckle = Objects.requireNonNull(buckle, "buckle");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder propeller(Angle propeller) {
            this.propeller = Objects.requireNonNull(propeller, "propeller");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder opening(Angle opening) {
            this.opening = Objects.requireNonNull(opening, "opening");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder interBaseAngle(Angle interBaseAngle) {
            this.interBaseAngle = Objects.requireNonNull(interBaseAngle, "interBaseAngle");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableBasePairParameters build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBasePairParameters(null, this.shear, this.stretch, this.stagger, this.buckle, this.propeller, this.opening, this.interBaseAngle);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("shear");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("stretch");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("stagger");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("buckle");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("propeller");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("opening");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("interBaseAngle");
            }
            return "Cannot build BasePairParameters, some of required attributes are not set " + attributes;
        }
    }
}

