/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.rna;

import java.util.Arrays;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.math3.util.FastMath;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.circular.ImmutableAngle;
import pl.poznan.put.torsion.range.Range;
import pl.poznan.put.torsion.range.RangeDifference;
import pl.poznan.put.torsion.range.RangeProvider;

public enum ChiRange implements Range
{
    HIGH_ANTI("high anti", -90.0, -15.0),
    SYN("syn", -15.0, 110.0),
    ANTI("anti", 110.0, 270.0),
    INVALID("invalid", Double.NaN, Double.NaN);

    private static final MultiKeyMap<ChiRange, RangeDifference> DIFFERENCE_MAP;
    private static final RangeProvider PROVIDER;
    private final String displayName;
    private final Angle begin;
    private final Angle end;

    private ChiRange(String displayName, double begin, double end) {
        this.displayName = displayName;
        this.begin = ImmutableAngle.of(FastMath.toRadians((double)begin));
        this.end = ImmutableAngle.of(FastMath.toRadians((double)end));
    }

    public static RangeProvider getProvider() {
        return PROVIDER;
    }

    @Override
    public String displayName() {
        return this.displayName;
    }

    @Override
    public Angle begin() {
        return this.begin;
    }

    @Override
    public Angle end() {
        return this.end;
    }

    @Override
    public RangeDifference compare(Range other) {
        if (!(other instanceof ChiRange)) {
            throw new IllegalArgumentException("A ChiRange object can be compared only with other ChiRange object");
        }
        if (this == INVALID || other == INVALID) {
            return RangeDifference.INVALID;
        }
        return (RangeDifference)((Object)DIFFERENCE_MAP.get((Object)this, (Object)other));
    }

    static {
        DIFFERENCE_MAP = new MultiKeyMap();
        PROVIDER = angle -> Arrays.stream(ChiRange.values()).filter(range -> angle.isBetween(range.begin, range.end)).findFirst().orElse(INVALID);
        DIFFERENCE_MAP.put((Object)ANTI, (Object)ANTI, (Object)RangeDifference.EQUAL);
        DIFFERENCE_MAP.put((Object)ANTI, (Object)HIGH_ANTI, (Object)RangeDifference.SIMILAR);
        DIFFERENCE_MAP.put((Object)ANTI, (Object)SYN, (Object)RangeDifference.OPPOSITE);
        DIFFERENCE_MAP.put((Object)HIGH_ANTI, (Object)ANTI, (Object)RangeDifference.SIMILAR);
        DIFFERENCE_MAP.put((Object)HIGH_ANTI, (Object)HIGH_ANTI, (Object)RangeDifference.EQUAL);
        DIFFERENCE_MAP.put((Object)HIGH_ANTI, (Object)SYN, (Object)RangeDifference.DIFFERENT);
        DIFFERENCE_MAP.put((Object)SYN, (Object)ANTI, (Object)RangeDifference.OPPOSITE);
        DIFFERENCE_MAP.put((Object)SYN, (Object)HIGH_ANTI, (Object)RangeDifference.DIFFERENT);
        DIFFERENCE_MAP.put((Object)SYN, (Object)SYN, (Object)RangeDifference.EQUAL);
    }
}

