/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.rna;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.PdbNamedResidueIdentifier;
import pl.poznan.put.pdb.analysis.ImmutableDefaultPdbModel;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.pdb.analysis.PdbModel;
import pl.poznan.put.structure.CanonicalStructureExtractor;
import pl.poznan.put.structure.ClassifiedBasePair;
import pl.poznan.put.structure.formats.BpSeq;
import pl.poznan.put.structure.formats.ImmutableDefaultConverter;

public final class ChainReorderer {
    private static final SpearmansCorrelation SPEARMAN = new SpearmansCorrelation();

    private ChainReorderer() {
    }

    public static PdbModel reorderAtoms(PdbModel model) {
        PdbModel rna = model.filteredNewInstance(MoleculeType.RNA);
        return ChainReorderer.reorderAtoms(rna, CanonicalStructureExtractor.basePairs(rna));
    }

    public static PdbModel reorderAtoms(PdbModel model, Collection<? extends ClassifiedBasePair> basePairs) {
        PdbModel rna = model.filteredNewInstance(MoleculeType.RNA);
        List<String> order = ChainReorderer.chainOrder(rna.namedResidueIdentifiers(), basePairs);
        List<PdbAtomLine> atoms = rna.atoms().stream().sorted(Comparator.comparingInt(t -> order.indexOf(t.chainIdentifier()))).collect(Collectors.toList());
        return ImmutableDefaultPdbModel.of(rna.header(), rna.experimentalData(), rna.resolution(), rna.modelNumber(), atoms, rna.modifiedResidues(), rna.missingResidues(), rna.title(), rna.chainTerminatedAfter());
    }

    private static List<String> chainOrder(Collection<PdbNamedResidueIdentifier> residues, Collection<? extends ClassifiedBasePair> basePairs) {
        List<String> distinct = residues.stream().map(PdbNamedResidueIdentifier::chainIdentifier).distinct().collect(Collectors.toList());
        if (distinct.size() <= 2) {
            return distinct;
        }
        Map<String, Set<String>> graph = ChainReorderer.buildGraph(basePairs);
        HashSet<String> visited = new HashSet<String>();
        ArrayList<String> order = new ArrayList<String>();
        for (String chain : distinct) {
            if (visited.contains(chain)) continue;
            ArrayList<String> component = new ArrayList<String>();
            ChainReorderer.depthFirstSearch(chain, graph, visited, component);
            order.addAll(ChainReorderer.componentOrder(component, distinct, residues, basePairs));
        }
        return order;
    }

    private static List<String> componentOrder(List<String> component, List<String> originalChainOrder, Collection<PdbNamedResidueIdentifier> residues, Collection<? extends ClassifiedBasePair> basePairs) {
        TreeMap map = new TreeMap();
        CollectionUtils.permutations(component).forEach(order -> {
            int pseudoknots = ChainReorderer.countPseudoknots(order, residues, basePairs);
            map.putIfAbsent(pseudoknots, new ArrayList());
            ((List)map.get(pseudoknots)).add(order);
        });
        double[] yArray = IntStream.range(0, originalChainOrder.size()).filter(i -> component.contains(originalChainOrder.get(i))).mapToDouble(i -> i).toArray();
        return ((List)map.get(map.firstKey())).stream().map(candidate -> Pair.of((Object)candidate, (Object)ChainReorderer.spearmanCorrelation(originalChainOrder, yArray, candidate))).max(Comparator.comparingDouble(Pair::getValue)).map(Pair::getKey).orElse(component);
    }

    private static double spearmanCorrelation(List<String> originalChainOrder, double[] yArray, Collection<String> candidate) {
        double[] xArray = candidate.stream().map(originalChainOrder::indexOf).mapToDouble(i -> i.intValue()).toArray();
        return SPEARMAN.correlation(xArray, yArray);
    }

    private static int countPseudoknots(List<String> candidateOrder, Collection<PdbNamedResidueIdentifier> residues, Collection<? extends ClassifiedBasePair> basePairs) {
        List<PdbNamedResidueIdentifier> reordered = residues.stream().filter(identifier -> candidateOrder.contains(identifier.chainIdentifier())).sorted(Comparator.comparingInt(t -> candidateOrder.indexOf(t.chainIdentifier()))).collect(Collectors.toList());
        List filteredBasePairs = basePairs.stream().filter(basePair -> candidateOrder.contains(basePair.basePair().left().chainIdentifier())).filter(basePair -> candidateOrder.contains(basePair.basePair().right().chainIdentifier())).collect(Collectors.toList());
        BpSeq bpSeq = BpSeq.fromBasePairs(reordered, filteredBasePairs);
        ImmutableDefaultConverter converter = ImmutableDefaultConverter.of();
        return converter.convert(bpSeq).pseudoknotOrder();
    }

    private static Map<String, Set<String>> buildGraph(Collection<? extends ClassifiedBasePair> basePairs) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        basePairs.stream().map(ClassifiedBasePair::basePair).flatMap(basePair -> Stream.of(basePair, basePair.invert())).map(basePair -> Pair.of((Object)basePair.left().chainIdentifier(), (Object)basePair.right().chainIdentifier())).filter(pair -> !((String)pair.getLeft()).equals(pair.getRight())).distinct().forEach(pair -> {
            map.putIfAbsent((String)pair.getLeft(), new HashSet());
            ((Set)map.get(pair.getLeft())).add((String)pair.getRight());
        });
        return map;
    }

    private static void depthFirstSearch(String u, Map<String, Set<String>> graph, Collection<String> visited, Collection<String> component) {
        visited.add(u);
        component.add(u);
        for (String v : graph.getOrDefault(u, Collections.emptySet())) {
            if (visited.contains(v)) continue;
            ChainReorderer.depthFirstSearch(v, graph, visited, component);
        }
    }
}

