/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.rna;

import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.immutables.value.Value;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.circular.ImmutableAngle;
import pl.poznan.put.rna.ImmutableBasePairParameters;
import pl.poznan.put.rna.ImmutableStandardReferenceFrame;
import pl.poznan.put.rna.StandardReferenceFrame;

@Value.Immutable
public abstract class BasePairParameters {
    public static BasePairParameters of(StandardReferenceFrame primary, StandardReferenceFrame secondary) {
        StandardReferenceFrame corrected = primary.z().dotProduct((Vector)secondary.z()) > 0.0 ? secondary : ImmutableStandardReferenceFrame.copyOf(secondary).withY(secondary.y().negate()).withZ(secondary.z().negate());
        StandardReferenceFrame pairFrame = StandardReferenceFrame.ofBasePair(primary, corrected);
        double shear = pairFrame.origin().dotProduct((Vector)pairFrame.x());
        double stretch = pairFrame.origin().dotProduct((Vector)pairFrame.y());
        double stagger = pairFrame.origin().dotProduct((Vector)pairFrame.z());
        Angle buckle = Angle.torsionAngle(primary.z().negate(), pairFrame.x().negate(), corrected.z());
        Angle propeller = Angle.torsionAngle(primary.z().negate(), pairFrame.y().negate(), corrected.z());
        Angle opening = Angle.torsionAngle(primary.y().negate(), pairFrame.z().negate(), corrected.y());
        double interBaseAngle = FastMath.sqrt((double)(buckle.radians() * buckle.radians() + propeller.radians() * propeller.radians()));
        double correction = Vector3D.angle((Vector3D)primary.z(), (Vector3D)corrected.z()) / interBaseAngle;
        return ImmutableBasePairParameters.of(shear, stretch, stagger, ImmutableAngle.of(buckle.radians() * correction), ImmutableAngle.of(propeller.radians() * correction), opening, ImmutableAngle.of(interBaseAngle * correction));
    }

    @Value.Parameter(order=1)
    public abstract double shear();

    @Value.Parameter(order=2)
    public abstract double stretch();

    @Value.Parameter(order=3)
    public abstract double stagger();

    @Value.Parameter(order=4)
    public abstract Angle buckle();

    @Value.Parameter(order=5)
    public abstract Angle propeller();

    @Value.Parameter(order=6)
    public abstract Angle opening();

    @Value.Parameter(order=7)
    public abstract Angle interBaseAngle();
}

