/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.protein;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.pdb.analysis.ResidueComponent;
import pl.poznan.put.protein.AminoAcidTorsionAngle;
import pl.poznan.put.protein.Chi1;
import pl.poznan.put.protein.ImmutableBackbone;
import pl.poznan.put.protein.ImmutableSerine;
import pl.poznan.put.protein.Sidechain;
import pl.poznan.put.torsion.TorsionAngleType;

@Value.Immutable(singleton=true)
abstract class Serine
implements Sidechain {
    Serine() {
    }

    @Override
    public final List<ResidueComponent> moleculeComponents() {
        return Stream.of(ImmutableBackbone.of(), ImmutableSerine.of()).collect(Collectors.toList());
    }

    @Override
    public final char oneLetterName() {
        return 'S';
    }

    @Override
    public final List<String> aliases() {
        return Collections.singletonList("SER");
    }

    @Override
    public final List<TorsionAngleType> torsionAngleTypes() {
        return Stream.of(AminoAcidTorsionAngle.PHI.angleTypes().get(0), AminoAcidTorsionAngle.PSI.angleTypes().get(0), AminoAcidTorsionAngle.OMEGA.angleTypes().get(0), AminoAcidTorsionAngle.CALPHA.angleTypes().get(0), Chi1.getInstance(Chi1.SERINE_ATOMS)).collect(Collectors.toList());
    }

    @Override
    public final Set<AtomName> requiredAtoms() {
        return Stream.of(AtomName.CB, AtomName.HB1, AtomName.HB2, AtomName.OG, AtomName.HG1).collect(Collectors.toSet());
    }
}

