/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.protein;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.torsion.ImmutableAtomBasedTorsionAngleType;
import pl.poznan.put.torsion.TorsionAngleType;
import pl.poznan.put.types.ImmutableQuadruple;
import pl.poznan.put.types.Quadruple;

final class Chi4 {
    public static final Quadruple<AtomName> ARGININE_ATOMS = ImmutableQuadruple.of(AtomName.CG, AtomName.CD, AtomName.NE, AtomName.CZ);
    public static final Quadruple<AtomName> LYSINE_ATOMS = ImmutableQuadruple.of(AtomName.CG, AtomName.CD, AtomName.CE, AtomName.NZ);
    private static final Map<Quadruple<AtomName>, TorsionAngleType> ANGLE_MAP = Stream.of(ARGININE_ATOMS, LYSINE_ATOMS).collect(Collectors.toSet()).stream().collect(Collectors.toMap(Function.identity(), quad -> ImmutableAtomBasedTorsionAngleType.of(MoleculeType.PROTEIN, "\u03c74", "chi4", quad, ImmutableQuadruple.of(0, 0, 0, 0))));

    private Chi4() {
    }

    public static Collection<TorsionAngleType> angleTypes() {
        return ANGLE_MAP.values();
    }

    public static TorsionAngleType getInstance(Quadruple<AtomName> chiAtoms) {
        return ANGLE_MAP.get(chiAtoms);
    }
}

