/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.protein;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.torsion.ImmutableAtomBasedTorsionAngleType;
import pl.poznan.put.torsion.TorsionAngleType;
import pl.poznan.put.types.ImmutableQuadruple;
import pl.poznan.put.types.Quadruple;

final class Chi2 {
    public static final Quadruple<AtomName> ARGININE_ATOMS = ImmutableQuadruple.of(AtomName.CA, AtomName.CB, AtomName.CG, AtomName.CD);
    public static final Quadruple<AtomName> ASPARAGINE_ATOMS = ImmutableQuadruple.of(AtomName.CA, AtomName.CB, AtomName.CG, AtomName.OD1);
    public static final Quadruple<AtomName> ASPARTIC_ACID_ATOMS = ImmutableQuadruple.of(AtomName.CA, AtomName.CB, AtomName.CG, AtomName.OD1);
    public static final Quadruple<AtomName> GLUTAMIC_ACID_ATOMS = ImmutableQuadruple.of(AtomName.CA, AtomName.CB, AtomName.CG, AtomName.CD);
    public static final Quadruple<AtomName> GLUTAMINE_ATOMS = ImmutableQuadruple.of(AtomName.CA, AtomName.CB, AtomName.CG, AtomName.CD);
    public static final Quadruple<AtomName> HISTIDINE_ATOMS = ImmutableQuadruple.of(AtomName.CA, AtomName.CB, AtomName.CG, AtomName.ND1);
    public static final Quadruple<AtomName> ISOLEUCINE_ATOMS = ImmutableQuadruple.of(AtomName.CA, AtomName.CB, AtomName.CG1, AtomName.CD1);
    public static final Quadruple<AtomName> LEUCINE_ATOMS = ImmutableQuadruple.of(AtomName.CA, AtomName.CB, AtomName.CG, AtomName.CD1);
    public static final Quadruple<AtomName> LYSINE_ATOMS = ImmutableQuadruple.of(AtomName.CA, AtomName.CB, AtomName.CG, AtomName.CD);
    public static final Quadruple<AtomName> METHIONINE_ATOMS = ImmutableQuadruple.of(AtomName.CA, AtomName.CB, AtomName.CG, AtomName.SD);
    public static final Quadruple<AtomName> PHENYLALANINE_ATOMS = ImmutableQuadruple.of(AtomName.CA, AtomName.CB, AtomName.CG, AtomName.CD1);
    public static final Quadruple<AtomName> PROLINE_ATOMS = ImmutableQuadruple.of(AtomName.CA, AtomName.CB, AtomName.CG, AtomName.CD);
    public static final Quadruple<AtomName> TRYPTOPHAN_ATOMS = ImmutableQuadruple.of(AtomName.CA, AtomName.CB, AtomName.CG, AtomName.CD1);
    public static final Quadruple<AtomName> TYROSINE_ATOMS = ImmutableQuadruple.of(AtomName.CA, AtomName.CB, AtomName.CG, AtomName.CD1);
    private static final Map<Quadruple<AtomName>, TorsionAngleType> ANGLE_MAP = Stream.of(ARGININE_ATOMS, ASPARAGINE_ATOMS, ASPARTIC_ACID_ATOMS, GLUTAMIC_ACID_ATOMS, GLUTAMINE_ATOMS, HISTIDINE_ATOMS, ISOLEUCINE_ATOMS, LEUCINE_ATOMS, LYSINE_ATOMS, METHIONINE_ATOMS, PHENYLALANINE_ATOMS, PROLINE_ATOMS, TRYPTOPHAN_ATOMS).collect(Collectors.toSet()).stream().collect(Collectors.toMap(Function.identity(), quad -> ImmutableAtomBasedTorsionAngleType.of(MoleculeType.PROTEIN, "\u03c72", "chi2", quad, ImmutableQuadruple.of(0, 0, 0, 0))));

    private Chi2() {
    }

    public static Collection<TorsionAngleType> angleTypes() {
        return ANGLE_MAP.values();
    }

    public static TorsionAngleType getInstance(Quadruple<AtomName> chiAtoms) {
        return ANGLE_MAP.get(chiAtoms);
    }
}

