/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.protein;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.protein.Chi1;
import pl.poznan.put.protein.Chi2;
import pl.poznan.put.protein.Chi3;
import pl.poznan.put.protein.Chi4;
import pl.poznan.put.protein.Chi5;
import pl.poznan.put.torsion.ImmutableAtomBasedTorsionAngleType;
import pl.poznan.put.torsion.MasterTorsionAngleType;
import pl.poznan.put.torsion.TorsionAngleType;
import pl.poznan.put.torsion.range.Range;
import pl.poznan.put.torsion.range.TorsionRange;
import pl.poznan.put.types.ImmutableQuadruple;

public final class AminoAcidTorsionAngle
extends Enum<AminoAcidTorsionAngle>
implements MasterTorsionAngleType {
    public static final /* enum */ AminoAcidTorsionAngle PHI = new AminoAcidTorsionAngle(ImmutableAtomBasedTorsionAngleType.of(MoleculeType.PROTEIN, "\u03d5", "phi", ImmutableQuadruple.of(AtomName.C, AtomName.N, AtomName.CA, AtomName.C), ImmutableQuadruple.of(-1, 0, 0, 0)));
    public static final /* enum */ AminoAcidTorsionAngle PSI = new AminoAcidTorsionAngle(ImmutableAtomBasedTorsionAngleType.of(MoleculeType.PROTEIN, "\u03c8", "psi", ImmutableQuadruple.of(AtomName.N, AtomName.CA, AtomName.C, AtomName.N), ImmutableQuadruple.of(0, 0, 0, 1)));
    public static final /* enum */ AminoAcidTorsionAngle OMEGA = new AminoAcidTorsionAngle(ImmutableAtomBasedTorsionAngleType.of(MoleculeType.PROTEIN, "\u03c9", "omega", ImmutableQuadruple.of(AtomName.CA, AtomName.C, AtomName.N, AtomName.CA), ImmutableQuadruple.of(0, 0, 1, 1)));
    public static final /* enum */ AminoAcidTorsionAngle CALPHA = new AminoAcidTorsionAngle(ImmutableAtomBasedTorsionAngleType.builder().moleculeType(MoleculeType.PROTEIN).shortDisplayName("C\u03b1").exportName("c-alpha").atoms(ImmutableQuadruple.of(AtomName.CA, AtomName.CA, AtomName.CA, AtomName.CA)).residueRule(ImmutableQuadruple.of(0, 1, 2, 3)).isPseudoTorsion(true).build());
    public static final /* enum */ AminoAcidTorsionAngle CHI1 = new AminoAcidTorsionAngle(Chi1.angleTypes());
    public static final /* enum */ AminoAcidTorsionAngle CHI2 = new AminoAcidTorsionAngle(Chi2.angleTypes());
    public static final /* enum */ AminoAcidTorsionAngle CHI3 = new AminoAcidTorsionAngle(Chi3.angleTypes());
    public static final /* enum */ AminoAcidTorsionAngle CHI4 = new AminoAcidTorsionAngle(Chi4.angleTypes());
    public static final /* enum */ AminoAcidTorsionAngle CHI5 = new AminoAcidTorsionAngle(Chi5.angleTypes());
    private final List<TorsionAngleType> angleTypes;
    private static final /* synthetic */ AminoAcidTorsionAngle[] $VALUES;

    public static AminoAcidTorsionAngle[] values() {
        return (AminoAcidTorsionAngle[])$VALUES.clone();
    }

    public static AminoAcidTorsionAngle valueOf(String name) {
        return Enum.valueOf(AminoAcidTorsionAngle.class, name);
    }

    private AminoAcidTorsionAngle(TorsionAngleType ... angleTypes) {
        this.angleTypes = Arrays.asList(angleTypes);
    }

    private AminoAcidTorsionAngle(Collection<TorsionAngleType> angleTypes) {
        this.angleTypes = new ArrayList<TorsionAngleType>(angleTypes);
    }

    @Override
    public List<TorsionAngleType> angleTypes() {
        return Collections.unmodifiableList(this.angleTypes);
    }

    @Override
    public Range range(Angle angle) {
        return TorsionRange.rangeProvider().fromAngle(angle);
    }

    @Override
    public String shortDisplayName() {
        assert (!this.angleTypes.isEmpty());
        return this.angleTypes.get(0).shortDisplayName();
    }

    @Override
    public String longDisplayName() {
        assert (!this.angleTypes.isEmpty());
        return this.angleTypes.get(0).longDisplayName();
    }

    @Override
    public String exportName() {
        assert (!this.angleTypes.isEmpty());
        return this.angleTypes.get(0).exportName();
    }

    static {
        $VALUES = new AminoAcidTorsionAngle[]{PHI, PSI, OMEGA, CALPHA, CHI1, CHI2, CHI3, CHI4, CHI5};
    }
}

