/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.protein;

import java.util.List;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.pdb.analysis.ResidueComponent;
import pl.poznan.put.pdb.analysis.ResidueInformationProvider;
import pl.poznan.put.protein.ImmutableAlanine;
import pl.poznan.put.protein.ImmutableArginine;
import pl.poznan.put.protein.ImmutableAsparagine;
import pl.poznan.put.protein.ImmutableAsparticAcid;
import pl.poznan.put.protein.ImmutableCysteine;
import pl.poznan.put.protein.ImmutableGlutamicAcid;
import pl.poznan.put.protein.ImmutableGlutamine;
import pl.poznan.put.protein.ImmutableGlycine;
import pl.poznan.put.protein.ImmutableHistidine;
import pl.poznan.put.protein.ImmutableIsoLeucine;
import pl.poznan.put.protein.ImmutableLeucine;
import pl.poznan.put.protein.ImmutableLysine;
import pl.poznan.put.protein.ImmutableMethionine;
import pl.poznan.put.protein.ImmutablePhenylalanine;
import pl.poznan.put.protein.ImmutableProline;
import pl.poznan.put.protein.ImmutableSerine;
import pl.poznan.put.protein.ImmutableThreonine;
import pl.poznan.put.protein.ImmutableTryptophan;
import pl.poznan.put.protein.ImmutableTyrosine;
import pl.poznan.put.protein.ImmutableValine;
import pl.poznan.put.protein.Sidechain;
import pl.poznan.put.torsion.TorsionAngleType;

public enum AminoAcid implements ResidueInformationProvider
{
    ALANINE(ImmutableAlanine.of()),
    ARGININE(ImmutableArginine.of()),
    ASPARAGINE(ImmutableAsparagine.of()),
    ASPARTIC_ACID(ImmutableAsparticAcid.of()),
    CYSTEINE(ImmutableCysteine.of()),
    GLUTAMIC_ACID(ImmutableGlutamicAcid.of()),
    GLUTAMINE(ImmutableGlutamine.of()),
    GLYCINE(ImmutableGlycine.of()),
    HISTIDINE(ImmutableHistidine.of()),
    ISOLEUCINE(ImmutableIsoLeucine.of()),
    LEUCINE(ImmutableLeucine.of()),
    LYSINE(ImmutableLysine.of()),
    METHIONINE(ImmutableMethionine.of()),
    PHENYLALANINE(ImmutablePhenylalanine.of()),
    PROLINE(ImmutableProline.of()),
    SERINE(ImmutableSerine.of()),
    THREONINE(ImmutableThreonine.of()),
    TRYPTOPHAN(ImmutableTryptophan.of()),
    TYROSINE(ImmutableTyrosine.of()),
    VALINE(ImmutableValine.of());

    private final Sidechain sidechain;

    private AminoAcid(Sidechain sidechain) {
        this.sidechain = sidechain;
    }

    public Sidechain sidechain() {
        return this.sidechain;
    }

    @Override
    public MoleculeType moleculeType() {
        return MoleculeType.PROTEIN;
    }

    @Override
    public List<ResidueComponent> moleculeComponents() {
        return this.sidechain.moleculeComponents();
    }

    @Override
    public char oneLetterName() {
        return this.sidechain.oneLetterName();
    }

    @Override
    public List<String> aliases() {
        return this.sidechain.aliases();
    }

    @Override
    public List<TorsionAngleType> torsionAngleTypes() {
        return this.sidechain.torsionAngleTypes();
    }
}

