/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.protein;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.pdb.analysis.ResidueComponent;
import pl.poznan.put.protein.AminoAcidTorsionAngle;
import pl.poznan.put.protein.ImmutableAlanine;
import pl.poznan.put.protein.ImmutableBackbone;
import pl.poznan.put.protein.Sidechain;
import pl.poznan.put.torsion.TorsionAngleType;

@Value.Immutable(singleton=true)
abstract class Alanine
implements Sidechain {
    Alanine() {
    }

    @Override
    public final List<ResidueComponent> moleculeComponents() {
        return Stream.of(ImmutableBackbone.of(), ImmutableAlanine.of()).collect(Collectors.toList());
    }

    @Override
    public final char oneLetterName() {
        return 'A';
    }

    @Override
    public final List<String> aliases() {
        return Collections.singletonList("ALA");
    }

    @Override
    public final List<TorsionAngleType> torsionAngleTypes() {
        return Stream.of(AminoAcidTorsionAngle.PHI.angleTypes().get(0), AminoAcidTorsionAngle.PSI.angleTypes().get(0), AminoAcidTorsionAngle.OMEGA.angleTypes().get(0), AminoAcidTorsionAngle.CALPHA.angleTypes().get(0)).collect(Collectors.toList());
    }

    @Override
    public final Set<AtomName> requiredAtoms() {
        return Stream.of(AtomName.CB, AtomName.HB1, AtomName.HB2, AtomName.HB3).collect(Collectors.toSet());
    }
}

