/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.SetUtils;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.pdb.analysis.ImmutableInvalidResidueInformationProvider;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.pdb.analysis.ResidueInformationProvider;
import pl.poznan.put.protein.AminoAcid;
import pl.poznan.put.protein.ImmutableBackbone;
import pl.poznan.put.rna.ImmutableRibose;
import pl.poznan.put.rna.Nucleotide;

public final class ResidueTypeDetector {
    private static final Set<AtomName> RIBOSE_HEAVY_ATOMS = ImmutableRibose.of().requiredAtoms().stream().filter(AtomName::isHeavy).collect(Collectors.toSet());
    private static final Set<AtomName> BACKBONE_HEAVY_ATOMS = ImmutableBackbone.of().requiredAtoms().stream().filter(AtomName::isHeavy).collect(Collectors.toSet());

    private ResidueTypeDetector() {
    }

    public static ResidueInformationProvider detectResidueType(String residueName, Set<AtomName> atomNames) {
        ResidueInformationProvider provider = ResidueTypeDetector.detectResidueTypeFromResidueName(residueName);
        if (provider.moleculeType() != MoleculeType.UNKNOWN) {
            return provider;
        }
        return ResidueTypeDetector.detectResidueTypeFromAtoms(atomNames, residueName);
    }

    private static ResidueInformationProvider detectResidueTypeFromResidueName(String residueName) {
        Stream<AminoAcid> stream = Stream.concat(Arrays.stream(Nucleotide.values()), Arrays.stream(AminoAcid.values()));
        return stream.filter(provider -> provider.aliases().contains(residueName)).findFirst().orElse(ImmutableInvalidResidueInformationProvider.of(residueName));
    }

    private static ResidueInformationProvider detectResidueTypeFromAtoms(Set<AtomName> actual, String residueName) {
        if (actual.size() > 1) {
            if (ResidueTypeDetector.isNucleotide(actual)) {
                return Arrays.stream(Nucleotide.values()).max(Comparator.comparingDouble(nucleotide -> ResidueTypeDetector.intersectionRatio(actual, nucleotide.nucleobase().requiredAtoms()))).orElseThrow(() -> new IllegalArgumentException("Failed to match any nucleobase to provided atom names"));
            }
            if (ResidueTypeDetector.isAminoAcid(actual)) {
                return Arrays.stream(AminoAcid.values()).max(Comparator.comparingDouble(aminoAcid -> ResidueTypeDetector.intersectionRatio(actual, aminoAcid.sidechain().requiredAtoms()))).orElseThrow(() -> new IllegalArgumentException("Failed to match any sidechain to provided atom names"));
            }
        }
        return ImmutableInvalidResidueInformationProvider.of(residueName);
    }

    private static boolean isNucleotide(Set<AtomName> actual) {
        return ResidueTypeDetector.intersectionRatio(actual, RIBOSE_HEAVY_ATOMS) >= 0.5;
    }

    private static double intersectionRatio(Set<AtomName> actual, Set<AtomName> expected) {
        return (double)SetUtils.intersection(actual, expected).size() / (double)expected.size();
    }

    private static boolean isAminoAcid(Set<AtomName> actual) {
        return ResidueTypeDetector.intersectionRatio(actual, BACKBONE_HEAVY_ATOMS) >= 0.5;
    }
}

