/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.circular.ImmutableAngle;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.pdb.analysis.ImmutableResidueTorsionAngles;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.torsion.MasterTorsionAngleType;
import pl.poznan.put.torsion.TorsionAngleType;
import pl.poznan.put.torsion.TorsionAngleValue;

@Value.Immutable
public abstract class ResidueTorsionAngles {
    public static ResidueTorsionAngles calculate(List<PdbResidue> residues, int index) {
        PdbResidue residue = residues.get(index);
        return ImmutableResidueTorsionAngles.of(residue.identifier(), residue.residueInformationProvider().torsionAngleTypes().stream().map(type -> type.calculate(residues, index)).collect(Collectors.toList()));
    }

    @Value.Parameter(order=1)
    public abstract PdbResidueIdentifier identifier();

    @Value.Parameter(order=2)
    protected abstract List<TorsionAngleValue> values();

    public final Angle value(TorsionAngleType type) {
        return this.values().stream().filter(angle -> Objects.equals(angle.angleType(), type)).map(TorsionAngleValue::value).findFirst().orElse(ImmutableAngle.of(Double.NaN));
    }

    public final Angle value(MasterTorsionAngleType masterType) {
        return this.values().stream().flatMap(angleValue -> masterType.angleTypes().stream().map(this::value)).filter(Angle::isValid).findFirst().orElse(ImmutableAngle.of(Double.NaN));
    }
}

