/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.pdb.ChainNumberICode;
import pl.poznan.put.pdb.ImmutablePdbAtomLine;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.PdbNamedResidueIdentifier;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.pdb.analysis.ImmutableDefaultPdbResidue;
import pl.poznan.put.pdb.analysis.ImmutableDefaultResidueCollection;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.pdb.analysis.ResidueInformationProvider;
import pl.poznan.put.rna.NucleotideTorsionAngle;
import pl.poznan.put.torsion.AtomBasedTorsionAngleType;
import pl.poznan.put.torsion.AtomPair;

@FunctionalInterface
public interface ResidueCollection
extends Serializable {
    public List<PdbResidue> residues();

    default public ResidueCollection withoutAlternateLocations() {
        ArrayList<PdbResidue> residues = new ArrayList<PdbResidue>();
        for (PdbResidue residue : this.residues()) {
            EnumSet<AtomName> resolved = EnumSet.noneOf(AtomName.class);
            ArrayList<ImmutablePdbAtomLine> atoms = new ArrayList<ImmutablePdbAtomLine>();
            for (PdbAtomLine atom : residue.atoms()) {
                if (resolved.contains((Object)atom.detectAtomName())) continue;
                atoms.add(ImmutablePdbAtomLine.copyOf(atom).withAlternateLocation(" "));
                resolved.add(atom.detectAtomName());
            }
            residues.add(ImmutableDefaultPdbResidue.of(residue.identifier(), residue.standardResidueName(), residue.modifiedResidueName(), atoms));
        }
        return ImmutableDefaultResidueCollection.of(residues);
    }

    default public List<String> findBondLengthViolations() {
        Set angleTypes = this.residues().stream().map(PdbResidue::residueInformationProvider).map(ResidueInformationProvider::torsionAngleTypes).flatMap(Collection::stream).filter(torsionAngleType -> torsionAngleType instanceof AtomBasedTorsionAngleType).map(torsionAngleType -> (AtomBasedTorsionAngleType)torsionAngleType).filter(torsionAngleType -> !torsionAngleType.isPseudoTorsion()).filter(torsionAngleType -> !NucleotideTorsionAngle.CHI.angleTypes().contains(torsionAngleType)).collect(Collectors.toSet());
        Set atomPairs = IntStream.range(0, this.residues().size()).boxed().flatMap(i -> angleTypes.stream().map(angleType -> angleType.findAtomPairs(this.residues(), (int)i)).flatMap(Collection::stream)).collect(Collectors.toCollection(TreeSet::new));
        return atomPairs.stream().map(AtomPair::generateValidationMessage).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    default public boolean hasResidue(ChainNumberICode query) {
        PdbResidueIdentifier queryIdentifier = PdbResidueIdentifier.from(query);
        return this.residues().stream().map(PdbResidueIdentifier::from).anyMatch(queryIdentifier::equals);
    }

    default public PdbResidue findResidue(ChainNumberICode query) {
        PdbResidueIdentifier queryIdentifier = PdbResidueIdentifier.from(query);
        return this.residues().stream().filter(residue -> Objects.equals(PdbResidueIdentifier.from(residue), queryIdentifier)).findFirst().orElseThrow(() -> new IllegalArgumentException("Failed to find residue: " + query));
    }

    default public int indexOf(ChainNumberICode query) {
        PdbResidueIdentifier identifier = PdbResidueIdentifier.from(query);
        return IntStream.range(0, this.residues().size()).filter(i -> PdbResidueIdentifier.from(this.residues().get(i)).equals(identifier)).findFirst().orElseThrow(() -> new IllegalArgumentException("Failed to find residue: " + identifier));
    }

    default public String sequence() {
        return this.residues().stream().map(PdbResidue::oneLetterName).map(String::valueOf).collect(Collectors.joining());
    }

    default public List<PdbAtomLine> filteredAtoms(MoleculeType moleculeType) {
        return this.residues().stream().filter(pdbResidue -> pdbResidue.residueInformationProvider().moleculeType() == moleculeType).filter(pdbResidue -> !pdbResidue.isMissing()).flatMap(pdbResidue -> pdbResidue.atoms().stream()).collect(Collectors.toList());
    }

    default public List<PdbResidueIdentifier> residueIdentifiers() {
        return this.residues().stream().map(PdbResidueIdentifier::from).collect(Collectors.toList());
    }

    default public List<PdbNamedResidueIdentifier> namedResidueIdentifiers() {
        return this.residues().stream().map(PdbResidue::namedResidueIdentifier).collect(Collectors.toList());
    }

    default public String toPdb() {
        StringBuilder builder = new StringBuilder();
        for (PdbResidue residue : this.residues()) {
            builder.append(residue.toPdb());
            builder.append('\n');
        }
        return builder.toString();
    }

    default public String toCif() {
        StringBuilder builder = new StringBuilder();
        builder.append("data_").append('\n');
        builder.append("loop_\n_atom_site.group_PDB\n_atom_site.id\n_atom_site.auth_atom_id\n_atom_site.label_alt_id\n_atom_site.auth_comp_id\n_atom_site.auth_asym_id\n_atom_site.auth_seq_id\n_atom_site.pdbx_PDB_ins_code\n_atom_site.Cartn_x\n_atom_site.Cartn_y\n_atom_site.Cartn_z\n_atom_site.occupancy\n_atom_site.B_iso_or_equiv\n_atom_site.type_symbol\n_atom_site.pdbx_formal_charge").append('\n');
        for (PdbResidue residue : this.residues()) {
            builder.append(residue.toCif());
            builder.append('\n');
        }
        return builder.toString();
    }
}

