/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.math3.geometry.euclidean.threed.Plane;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.pdb.ChainNumberICode;
import pl.poznan.put.pdb.ImmutablePdbNamedResidueIdentifier;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.PdbNamedResidueIdentifier;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.pdb.analysis.ResidueComponent;
import pl.poznan.put.pdb.analysis.ResidueInformationProvider;
import pl.poznan.put.pdb.analysis.ResidueTypeDetector;
import pl.poznan.put.rna.Nucleotide;

public interface PdbResidue
extends ChainNumberICode {
    public PdbResidueIdentifier identifier();

    public String standardResidueName();

    public String modifiedResidueName();

    public List<PdbAtomLine> atoms();

    default public String toPdb() {
        return this.atoms().stream().map(String::valueOf).collect(Collectors.joining("\n"));
    }

    default public String toCif() {
        return this.atoms().stream().map(PdbAtomLine::toCif).collect(Collectors.joining("\n"));
    }

    default public boolean isMissing() {
        return this.atoms().isEmpty();
    }

    default public ResidueInformationProvider residueInformationProvider() {
        return ResidueTypeDetector.detectResidueType(this.modifiedResidueName(), this.atomNames());
    }

    default public char oneLetterName() {
        return this.isModified() ? Character.toLowerCase(this.residueInformationProvider().oneLetterName()) : this.residueInformationProvider().oneLetterName();
    }

    default public boolean isConnectedTo(PdbResidue other) {
        return this.residueInformationProvider().moleculeType().areConnected(this, other);
    }

    @Override
    default public String chainIdentifier() {
        return this.identifier().chainIdentifier();
    }

    @Override
    default public int residueNumber() {
        return this.identifier().residueNumber();
    }

    @Override
    default public String insertionCode() {
        return this.identifier().insertionCode();
    }

    default public PdbAtomLine findAtom(AtomName atomName) {
        return this.atoms().stream().filter(atom -> atom.detectAtomName() == atomName).findFirst().orElseThrow(() -> new IllegalArgumentException("Failed to find: " + (Object)((Object)atomName)));
    }

    default public Plane nucleobasePlane() {
        if (this.residueInformationProvider() instanceof Nucleotide) {
            switch ((Nucleotide)this.residueInformationProvider()) {
                case ADENINE: 
                case GUANINE: {
                    return new Plane(this.findAtom(AtomName.N9).toVector3D(), this.findAtom(AtomName.C2).toVector3D(), this.findAtom(AtomName.C6).toVector3D(), 0.001);
                }
                case CYTOSINE: 
                case URACIL: 
                case THYMINE: {
                    return new Plane(this.findAtom(AtomName.N1).toVector3D(), this.findAtom(AtomName.N3).toVector3D(), this.findAtom(AtomName.C5).toVector3D(), 0.001);
                }
            }
        }
        throw new IllegalArgumentException("Cannot compute base plane for not a nucleotide: " + this.identifier());
    }

    default public PdbNamedResidueIdentifier namedResidueIdentifier() {
        return ImmutablePdbNamedResidueIdentifier.of(this.identifier().chainIdentifier(), this.identifier().residueNumber(), this.identifier().insertionCode(), this.isModified() ? Character.toLowerCase(this.oneLetterName()) : this.oneLetterName());
    }

    default public Set<AtomName> atomNames() {
        return this.atoms().stream().map(PdbAtomLine::detectAtomName).collect(Collectors.toSet());
    }

    default public boolean hasAtom(AtomName atomName) {
        return this.atomNames().contains((Object)atomName);
    }

    default public boolean hasAnyHydrogen() {
        return this.atomNames().stream().anyMatch(atomName -> !atomName.isHeavy());
    }

    default public boolean hasAllHeavyAtoms() {
        Set heavyAtoms = this.atomNames().stream().filter(AtomName::isHeavy).collect(Collectors.toSet());
        Set expectedHeavyAtoms = this.residueInformationProvider().moleculeComponents().stream().map(ResidueComponent::requiredAtoms).flatMap(Collection::stream).filter(AtomName::isHeavy).collect(Collectors.toSet());
        return SetUtils.isEqualSet(heavyAtoms, expectedHeavyAtoms);
    }

    default public boolean isModified() {
        return !Objects.equals(this.standardResidueName(), this.modifiedResidueName()) || !this.isMissing() && !this.hasAllHeavyAtoms();
    }
}

