/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.poznan.put.pdb.ImmutablePdbExpdtaLine;
import pl.poznan.put.pdb.ImmutablePdbHeaderLine;
import pl.poznan.put.pdb.ImmutablePdbRemark2Line;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.PdbExpdtaLine;
import pl.poznan.put.pdb.PdbHeaderLine;
import pl.poznan.put.pdb.PdbModresLine;
import pl.poznan.put.pdb.PdbParsingException;
import pl.poznan.put.pdb.PdbRemark2Line;
import pl.poznan.put.pdb.PdbRemark465Line;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.pdb.PdbTitleLine;
import pl.poznan.put.pdb.analysis.ImmutableDefaultPdbModel;
import pl.poznan.put.pdb.analysis.PdbModel;

public class PdbParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdbParser.class);
    private final List<PdbModresLine> modifiedResidues = new ArrayList<PdbModresLine>();
    private final List<PdbRemark465Line> missingResidues = new ArrayList<PdbRemark465Line>();
    private final Collection<PdbResidueIdentifier> processedIdentifiers = new HashSet<PdbResidueIdentifier>();
    private final Set<PdbResidueIdentifier> chainTerminatedAfter = new HashSet<PdbResidueIdentifier>();
    private final Collection<Integer> endedModelNumbers = new HashSet<Integer>();
    private final Map<Integer, List<PdbAtomLine>> modelAtoms = new TreeMap<Integer, List<PdbAtomLine>>();
    private final Collection<PdbTitleLine> titleLines = new ArrayList<PdbTitleLine>();
    private final boolean strictMode;
    private Optional<PdbHeaderLine> headerLine = Optional.empty();
    private Optional<PdbExpdtaLine> experimentalDataLine = Optional.empty();
    private Optional<PdbRemark2Line> resolutionLine = Optional.empty();
    private Optional<PdbResidueIdentifier> currentIdentifier = Optional.empty();
    private int currentModelNumber;

    public PdbParser(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public PdbParser() {
        this.strictMode = true;
    }

    public final synchronized List<PdbModel> parse(String structureContent) {
        this.resetState();
        for (String line : structureContent.split("\n")) {
            if (line.startsWith("MODEL")) {
                this.handleModelLine(line);
                continue;
            }
            if (line.startsWith("ATOM") || line.startsWith("HETATM")) {
                this.handleAtomLine(line);
                continue;
            }
            if (line.startsWith("TER   ")) {
                this.handleTerLine();
                continue;
            }
            if (line.startsWith("REMARK 465")) {
                this.handleMissingResidueLine(line);
                continue;
            }
            if (line.startsWith("MODRES")) {
                this.handleModifiedResidueLine(line);
                continue;
            }
            if (line.startsWith("HEADER")) {
                this.handleHeaderLine(line);
                continue;
            }
            if (line.startsWith("EXPDTA")) {
                this.handleExperimentalDataLine(line);
                continue;
            }
            if (line.startsWith("REMARK   2 RESOLUTION.")) {
                this.handleResolutionLine(line);
                continue;
            }
            if (!line.startsWith("TITLE ")) continue;
            this.handleTitleLine(line);
        }
        String titleBuilder = this.titleLines.stream().map(PdbTitleLine::title).collect(Collectors.joining());
        ArrayList<PdbModel> result = new ArrayList<PdbModel>();
        for (Map.Entry<Integer, List<PdbAtomLine>> entry : this.modelAtoms.entrySet()) {
            int modelNumber = entry.getKey();
            List<PdbAtomLine> atoms = entry.getValue();
            ImmutableDefaultPdbModel structureModel = ImmutableDefaultPdbModel.of(this.headerLine.orElse(ImmutablePdbHeaderLine.of("", new Date(0L), "")), this.experimentalDataLine.orElse(ImmutablePdbExpdtaLine.of(Collections.emptyList())), this.resolutionLine.orElse(ImmutablePdbRemark2Line.of(Double.NaN)), modelNumber, atoms, this.modifiedResidues, this.missingResidues, titleBuilder, this.chainTerminatedAfter);
            result.add(structureModel);
        }
        return result;
    }

    private void resetState() {
        this.modifiedResidues.clear();
        this.missingResidues.clear();
        this.processedIdentifiers.clear();
        this.chainTerminatedAfter.clear();
        this.endedModelNumbers.clear();
        this.modelAtoms.clear();
        this.titleLines.clear();
        this.headerLine = Optional.empty();
        this.experimentalDataLine = Optional.empty();
        this.currentModelNumber = 0;
        this.currentIdentifier = Optional.empty();
    }

    private void handleModelLine(String line) {
        this.endedModelNumbers.add(this.currentModelNumber);
        String modelNumberString = line.length() > 14 ? line.substring(10, 14).trim() : line.substring(5).trim();
        int modelNumber = Integer.parseInt(modelNumberString);
        while (this.endedModelNumbers.contains(modelNumber)) {
            modelNumber = RandomUtils.nextInt((int)1, (int)10000);
        }
        this.currentModelNumber = modelNumber;
        this.processedIdentifiers.clear();
        this.chainTerminatedAfter.clear();
        this.currentIdentifier = Optional.empty();
    }

    private void handleAtomLine(String line) {
        try {
            PdbAtomLine atomLine = PdbAtomLine.parse(line, this.strictMode);
            PdbResidueIdentifier identifier = PdbResidueIdentifier.from(atomLine);
            if (this.processedIdentifiers.contains(identifier)) {
                LOGGER.warn("Duplicate residue, ignoring it: {}", (Object)identifier);
                return;
            }
            if (this.currentIdentifier.isPresent() && !identifier.equals(this.currentIdentifier.get())) {
                this.processedIdentifiers.add(this.currentIdentifier.get());
                this.currentIdentifier = Optional.of(identifier);
            }
            if (!this.modelAtoms.containsKey(this.currentModelNumber)) {
                this.modelAtoms.put(this.currentModelNumber, new ArrayList());
            }
            List<PdbAtomLine> atomList = this.modelAtoms.get(this.currentModelNumber);
            atomList.add(atomLine);
        }
        catch (PdbParsingException e) {
            LOGGER.warn("Invalid ATOM line: {}", (Object)line, (Object)e);
        }
    }

    private void handleTitleLine(String line) {
        try {
            PdbTitleLine titleLine = PdbTitleLine.parse(line);
            if (CollectionUtils.isEmpty(this.titleLines) && StringUtils.isBlank((CharSequence)titleLine.continuation()) || StringUtils.isNotBlank((CharSequence)titleLine.continuation())) {
                this.titleLines.add(titleLine);
            }
        }
        catch (PdbParsingException e) {
            LOGGER.warn("Invalid TITLE line: {}", (Object)line, (Object)e);
        }
    }

    private void handleTerLine() {
        List<PdbAtomLine> atomLines = this.modelAtoms.get(this.currentModelNumber);
        this.chainTerminatedAfter.add(PdbResidueIdentifier.from(atomLines.get(atomLines.size() - 1)));
    }

    private void handleMissingResidueLine(String line) {
        try {
            if (PdbRemark465Line.isCommentLine(line)) {
                return;
            }
            PdbRemark465Line remark465Line = PdbRemark465Line.parse(line);
            this.missingResidues.add(remark465Line);
        }
        catch (PdbParsingException e) {
            LOGGER.warn("Invalid REMARK 465 line: {}", (Object)line, (Object)e);
        }
    }

    private void handleModifiedResidueLine(String line) {
        try {
            PdbModresLine modresLine = PdbModresLine.parse(line);
            this.modifiedResidues.add(modresLine);
        }
        catch (PdbParsingException e) {
            LOGGER.warn("Invalid MODRES line: {}", (Object)line, (Object)e);
        }
    }

    private void handleHeaderLine(String line) {
        try {
            this.headerLine = Optional.of(PdbHeaderLine.parse(line));
        }
        catch (PdbParsingException e) {
            LOGGER.warn("Invalid HEADER line: {}", (Object)line, (Object)e);
        }
    }

    private void handleExperimentalDataLine(String line) {
        try {
            this.experimentalDataLine = Optional.of(PdbExpdtaLine.parse(line));
        }
        catch (PdbParsingException e) {
            LOGGER.warn("Invalid EXPDTA line: {}", (Object)line, (Object)e);
        }
    }

    private void handleResolutionLine(String line) {
        try {
            this.resolutionLine = Optional.of(PdbRemark2Line.parse(line));
        }
        catch (PdbParsingException e) {
            LOGGER.warn("Invalid REMARK   2 RESOLUTION. line: {}", (Object)line, (Object)e);
        }
    }
}

