/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import pl.poznan.put.pdb.ChainNumberICode;
import pl.poznan.put.pdb.ImmutablePdbRemark465Line;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.PdbExpdtaLine;
import pl.poznan.put.pdb.PdbHeaderLine;
import pl.poznan.put.pdb.PdbModresLine;
import pl.poznan.put.pdb.PdbRemark2Line;
import pl.poznan.put.pdb.PdbRemark465Line;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.pdb.analysis.PdbChain;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.pdb.analysis.ResidueCollection;
import pl.poznan.put.pdb.analysis.SingleTypedResidueCollection;

public interface PdbModel
extends ResidueCollection {
    public PdbHeaderLine header();

    public PdbExpdtaLine experimentalData();

    public PdbRemark2Line resolution();

    public int modelNumber();

    public List<PdbAtomLine> atoms();

    public List<PdbModresLine> modifiedResidues();

    public List<PdbRemark465Line> missingResidues();

    public String title();

    public Set<PdbResidueIdentifier> chainTerminatedAfter();

    public List<PdbChain> chains();

    public PdbModel filteredNewInstance(MoleculeType var1);

    default public String idCode() {
        return this.header().idCode();
    }

    default public boolean containsAny(MoleculeType moleculeType) {
        return this.chains().stream().anyMatch(chain -> chain.moleculeType() == moleculeType);
    }

    default public SingleTypedResidueCollection findChainContainingResidue(ChainNumberICode query) {
        return this.chains().stream().filter(pdbChain -> pdbChain.hasResidue(query)).findFirst().orElseThrow(() -> new IllegalArgumentException("Failed to find chain containing residue: " + query));
    }

    default public List<PdbRemark465Line> filteredMissing(MoleculeType moleculeType) {
        return this.residues().stream().filter(pdbResidue -> pdbResidue.residueInformationProvider().moleculeType() == moleculeType).filter(PdbResidue::isMissing).map(pdbResidue -> ImmutablePdbRemark465Line.of(this.modelNumber(), pdbResidue.standardResidueName(), pdbResidue.chainIdentifier(), pdbResidue.residueNumber(), pdbResidue.insertionCode())).collect(Collectors.toList());
    }

    default public boolean isModified(PdbResidueIdentifier query) {
        return this.modifiedResidues().stream().anyMatch(modifiedResidue -> PdbResidueIdentifier.from(modifiedResidue).equals(query));
    }

    default public PdbModresLine modificationDetails(PdbResidueIdentifier query) {
        return this.modifiedResidues().stream().filter(modifiedResidue -> PdbResidueIdentifier.from(modifiedResidue).equals(query)).findFirst().orElseThrow(() -> new IllegalArgumentException("Failed to find information about modification of: " + query));
    }
}

